#! /usr/bin/python2.7
# -*- coding: utf-8 -*-

"""
Copyright ou © ou Copr. Pierre Simon Garcia, Frédéric Jauffrit, Christophe Grangeasse,
Céline Brochier-Armanet, CNRS, UCBL, (02/06/2017)

pierre.garcia@etu.univ-lyon1.fr

Ce logiciel est un programme informatique servant à visualiser des contextes génomiques.

Ce logiciel est régi par la licence CeCILL soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site "http://www.cecill.info".

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée.  Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme,  le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard  l'attention de l'utilisateur est attirée sur les risques
associés au chargement,  à l'utilisation,  à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant  des  connaissances  informatiques approfondies.  Les
utilisateurs sont donc invités à charger  et  tester  l'adéquation  du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL, et que vous en avez accepté les
termes.


Copyright or © or Copr.  Pierre Simon Garcia, Frédéric Jauffrit, Christophe Grangeasse,
Céline Brochier-Armanet, CNRS, UCBL, (02/06/2017)

pierre.garcia@etu.univ-lyon1.fr

This software is a computer program whose purpose is to visualize genomic contexts.

This software is governed by the CeCILL license under French law and
abiding by the rules of distribution of free software.  You can  use,
modify and/ or redistribute the software under the terms of the CeCILL
license as circulated by CEA, CNRS and INRIA at the following URL
"http://www.cecill.info".

As a counterpart to the access to the source code and  rights to copy,
modify and redistribute granted by the license, users are provided only
with a limited warranty  and the software's author,  the holder of the
economic rights,  and the successive licensors  have only  limited
liability.

In this respect, the user's attention is drawn to the risks associated
with loading,  using,  modifying and/or developing or reproducing the
software by the user in light of its specific status of free software,
that may mean  that it is complicated to manipulate,  and  that  also
therefore means  that it is reserved for developers  and  experienced
professionals having in-depth computer knowledge. Users are therefore
encouraged to load and test the software's suitability as regards their
requirements in conditions enabling the security of their systems and/or
data to be ensured and,  more generally, to use and operate it in the
same conditions as regards security.

The fact that you are presently reading this means that you have had
knowledge of the CeCILL license and that you accept its terms.
"""
import random
import re
import sys
import os
import glob
import platform
import matplotlib
import gzip
from math import sqrt
matplotlib.use('Tkagg')
from matplotlib.backends.backend_tkagg import FigureCanvasTkAgg
from matplotlib.backends.backend_pdf import PdfPages
import matplotlib.pyplot as plt
import matplotlib.patches as patches
from matplotlib.figure import Figure
from Tkinter import *
from tkFileDialog import *
import tkFont
import ttk
import tkMessageBox
import urllib2
import sqlite3
from tkColorChooser import askcolor
import gc
#import rsrc
import webbrowser
import socket
import math
from StringIO import StringIO
socket.setdefaulttimeout(10)
#reload(sys)
#sys.setdefaultencoding('utf-8')
tab_link =  os.path.realpath(sys.argv[0]).split("\\")
prog_link = tab_link.pop()
path_anfile_g = "\\".join(tab_link)+"\\"
path_path = "\\".join(tab_link)+"\\PATHS_PARAMS.ini"


if os.path.isfile(path_path) is False:
    # print path_path
    sys.exit("ERROR : PATHS_PARAMS.ini not found in GeneSpy repertory")
pathr = open(path_path)
PATH = []
patht = pathr.readlines()
pathr.close()
for l in patht:
    if l.find("#")==-1:
        PATH.append(l.split("\t")[1].rstrip())
WARNING_g = []
dico_spec_clean_g = {}
list_contexts_g = []
dico_spec_g = {}
dico_final0_g = {}
tab_genes_g = []
liste_fig_g = []
sort_g = "fasta"
fen_g = 10000
col_g ="sen"
n_seq_g = 0
name_length_g = 0
path_infile_g = ""
WARNING_tot = 1
data_set_g = "file"
WP_appear = True
CONTIG_appear = True
NAME_appear = True
Size_arrow = 1000
expansion_g = 1
global_coloration = "normal"
threshold_memory = int(PATH[4].rstrip())
liste_canvas = []
dico_color_file = {}
dico_name_file = {}
file_color_g = ""
position_list_spec = 0
LOCTAG_appear = False
proxies = {}
if PATH[6].rstrip() != "":
    try:
        proxies[PATH[6].split("://")[0]] = PATH[6]
    except:
        print "Wrong proxy adress",PATH[6],". status: ignored."

class Gene(object):
    """Correspond to a gene and its attributes"""
    def __init__(self, start, end, strand,wp,loctag,annot,name):
        super(Gene, self).__init__()
        self.start = start
        self.end = end
        self.strand = strand
        self.wp = wp
        self.loctag = loctag
        self.annot = annot
        self.name = name

class ColorManager(object):
    """Manage colorations of arrows and name of genes on matplotlib Figure"""
    def __init__(self):
        super(ColorManager, self).__init__()
    def Files_Color(self,path_anfile,list_contexts):
        """get anterior colors that are stored in files of colorations
        and if a name/annotation has not an attributed color, use htmlcolor
        to attribute it"""
        dico_color = {}
        namer = readfile(path_anfile+"NameCol.txt")
        for i in namer:
            try:
                dico_color[i.split("\t")[0]] = i.split("\t")[1].rstrip()
            except:
                continue
        dico_color_annot = {}
        anotr = readfile(path_anfile+"AnnotCol.txt")
        for i in anotr:
            try:
                dico_color_annot[i.split("\t")[0]] = i.split("\t")[1].rstrip()
            except:
                continue
        dico_annot_name = {}
        corrr = readfile(path_anfile+"AnnotName.txt")
        for i in corrr:
            try:
                dico_annot_name[i.split("\t")[0]] = i.split("\t")[1].rstrip()
            except:
                continue
        dico_name_name = {}
        corr2r = readfile(path_anfile+"NameName.txt")
        for i in corr2r:
            try:
                dico_name_name[i.split("\t")[0].lower()[0:6]] = i.split("\t")[1].rstrip()
            except:
                continue
        del corr2r
        del corrr
        del anotr
        del namer
        corr2r = []
        corrr = []
        anotr = []
        namer = []
        namea = open(path_anfile+"NameCol.txt", "a")
        annota = open(path_anfile+"AnnotCol.txt", "a")
        corra = open(path_anfile+"AnnotName.txt", "a")#
        corr2a = open(path_anfile+"NameName.txt", "a")
        for n,context in enumerate(list_contexts):
            for gene in context.genes:
                if gene.name != "":
                    name = gene.name.lower()[0:6]
                    annot = gene.annot.lower()
                    if dico_color.has_key(name) is False:
                        color = self.htmlcolor(random.randint(0,255),random.randint(0,255),random.randint(0,255))
                        dico_color[name] = color
                        namea.write(name+"\t"+color+"\n")
                    if dico_annot_name.has_key(annot) is False:
                        dico_annot_name[annot] = name
                        corra.write(annot+"\t"+name+"\n")
                    if dico_name_name.has_key(name) is False:
                        dico_name_name[name] = gene.name
                        corr2a.write(name+"\t"+gene.name+"\n")
                else:
                    annot = gene.annot.lower()
                    if dico_color.has_key(annot) is False and annot != "hypothetical protein":
                        if dico_color_annot.has_key(annot) is False:
                            color = self.htmlcolor(random.randint(0,255),random.randint(0,255),random.randint(0,255))
                            dico_color_annot[annot] = color
                            annota.write(annot+"\t"+color+"\n")
        namea.close()
        annota.close()
        corra.close()
        corr2a.close()
        return dico_color,dico_color_annot,dico_annot_name,dico_name_name

    def htmlcolor(self,r, g, b):
        """generate a color (hexadecimal)"""
        def _chkarg(a):
            if isinstance(a, int): # clamp to range 0--255
                if a < 0:
                    a = 0
                elif a > 255:
                    a = 255
            elif isinstance(a, float): # clamp to range 0.0--1.0 and convert to integer 0--255
                if a < 0.0:
                    a = 0
                elif a > 1.0:
                    a = 255
                else:
                    a = int(round(a*255))
            else:
                raise ValueError('Arguments must be integers or floats.')
            # print a
            return a
        r = _chkarg(r)
        g = _chkarg(g)
        b = _chkarg(b)
        return '#{:02x}{:02x}{:02x}'.format(r,g,b)

    def Attribute_color(self,gene,global_coloration,fen,col,NAME_appear,Color_dictionaries):
        """set coloration of a gene considering its name and its annotation
        take into account options such as type of coloraiton or hide/show names
        set color of names showed in figure"""
        dico_color = Color_dictionaries[0]
        dico_color_annot = Color_dictionaries[1]
        dico_annot_name = Color_dictionaries[2]
        dico_name_name = Color_dictionaries[3]
        inf = gene.start
        sup = gene.end
        length = sup - inf
        annot = gene.annot
        sens = gene.strand
        wp = gene.wp
        val_x = inf
        color = ""
        alpha_col = 1
        length_x = length
        nom_printed = ""
        color_name="black"
        name = gene.name
        found = 0
        if found == 0:
            if annot == "hypothetical protein" or annot == "Hypothetical protein":
                if sens == "+":
                    color = "gray"
                    alpha_col = 1
                    length_x = length
                    val_x = inf
                else:
                    color = "gray"
                    alpha_col = 1
                    length_x = -length
                    val_x = sup
                nom_printed = name[0:6][:]
                found +=1
            if found == 0:
                if name == "tRNA" or name == "rRNA":
                    if sens == "+":
                        color = "white"
                        alpha_col = 1
                        length_x = length
                        val_x = inf
                    else:
                        color = "white"
                        alpha_col = 1
                        length_x = -length
                        val_x = sup
                    nom_printed = name[0:6][:]
                    found +=1
                if found == 0:
                    if dico_color.has_key(name.lower()[0:6]):
                        if sens == "+":
                            color = dico_color[name.lower()[0:6]][:]
                            alpha_col = 1
                            length_x = length
                            val_x = inf
                        else:
                            color = dico_color[name.lower()[0:6]][:]
                            alpha_col = 1
                            length_x = -length
                            val_x = sup
                        nom_printed = dico_name_name[name[0:6].lower()][:]
                        found +=1
                    if found == 0:
                        if dico_color.has_key(annot.lower().split(" ").pop()):
                            if sens == "+":
                                color = dico_color[annot.lower().split(" ").pop()][:]
                                alpha_col = 1
                                length_x = length
                                val_x = inf
                            else:
                                color = dico_color[annot.lower().split(" ").pop()][:]
                                alpha_col = 1
                                length_x = -length
                                val_x = sup
                            nom_printed = dico_name_name[annot.lower().split(" ").pop()][:]
                            found +=1
                        if found == 0:
                            if dico_annot_name.has_key(annot.lower()) is True:
                                real_name = dico_name_name[dico_annot_name[annot.lower()]]
                                if dico_annot_name[annot.lower()] == "_":
                                    found == 0
                                    # print "miaou"
                                else:
                                    found +=1
                                if col == "eq":
                                    if sens == "+":
                                        color = dico_color[dico_annot_name[annot.lower()]][:]
                                        alpha_col = 1
                                        length_x = length
                                        val_x = inf
                                    else:
                                        color = dico_color[dico_annot_name[annot.lower()]][:]
                                        alpha_col = 1
                                        length_x = -length
                                        val_x = sup
                                    nom_printed = real_name[0:6][:]
                                else:
                                    if sens == "+":
                                        color = dico_color[dico_annot_name[annot.lower()]][:]
                                        alpha_col = 0.5
                                        length_x = length
                                        val_x = inf
                                    else:
                                        color = dico_color[dico_annot_name[annot.lower()]][:]
                                        alpha_col = 0.5
                                        length_x = -length
                                        val_x = sup
                                    nom_printed = real_name[0:6][:]
                                    color_name="gray"
                            if found == 0:
                                if col == "eq":
                                    if dico_color_annot.has_key(annot.lower()):
                                        found +=1
                                        if sens == "+":
                                            color = dico_color_annot[annot.lower()][:]
                                            alpha_col = 1
                                            length_x = length
                                            val_x = inf
                                        else:
                                            color = dico_color_annot[annot.lower()][:]
                                            alpha_col = 1
                                            length_x = -length
                                            val_x = sup
                                else:
                                    if dico_color_annot.has_key(annot.lower()):
                                        found +=1
                                        if sens == "+":
                                            color = dico_color_annot[annot.lower()][:]
                                            alpha_col = 0.5
                                            length_x = length
                                            val_x = inf
                                        else:
                                            color = dico_color_annot[annot.lower()][:]
                                            alpha_col = 0.5
                                            length_x = -length
                                            val_x = sup
                                        color_name="gray"


                                if found == 0:
                                    if sens == "+":
                                        color = "white"
                                        alpha_col = 1
                                        length_x = length
                                        val_x = inf
                                    else:
                                        color = "white"
                                        alpha_col = 1
                                        length_x = -length
                                        val_x = sup

        if int((inf+sup)/float(2)) > fen-20 and int((inf+sup)/float(2)) < fen+20:
                color = "black"
                alpha_col = 1
        if global_coloration != "normal":
            if global_coloration == "file_annot":
                compteur_local = 0
                if dico_color_file.has_key(annot.lower()) is True:
                    color = dico_color_file[annot.lower()]
                    if dico_name_file[annot.lower()] != "NA":
                        nom_printed = dico_name_file[annot.lower()]
                    compteur_local = 1
                if dico_color_file.has_key(nom_printed.lower()) is True:
                    color = dico_color_file[nom_printed.lower()]
                    if dico_name_file[nom_printed.lower()] != "NA":
                        nom_printed = dico_name_file[nom_printed.lower()]
                    compteur_local = 1
                if dico_color_file.has_key(wp.lower()) is True:
                    color = dico_color_file[wp.lower()]
                    if dico_name_file[wp.lower()] != "NA":
                        nom_printed = dico_name_file[wp.lower()]
                    compteur_local = 1
                if compteur_local == 0:
                    color = "white"
            elif global_coloration == "file_wp":
                compteur_local = 0
                if dico_color_file.has_key(wp) is True:
                    color = dico_color_file[wp]
                    if dico_name_file[wp] != "NA":
                        nom_printed = dico_name_file[wp]
                    compteur_local = 1
                if compteur_local == 0:
                    color = "white"
            else:
                tab_global_coloration = global_coloration.split("#")
                for glob_col in tab_global_coloration:
                    if annot.lower().find(glob_col.lower())!=-1 or nom_printed.lower().find(glob_col.lower())!=-1:
                        color = "blue"
                        break
                    else:
                        color = "white"
        return color,alpha_col,val_x,length_x,nom_printed,color_name


class Context(object):
    """contains a set of genes"""
    def __init__(self,gca,wp,contig,spec,spec_c,index):
        super(Context, self).__init__()
        self.genes = []
        self.target_gca = gca
        self.target_wp = wp
        self.target_contig = contig
        self.target_spec = spec
        self.target_spec_c = spec_c
        self.target_index = index
    def add_gene(self, gene):
        """add a gene in context object"""
        self.genes.append(gene)
    def test_len(self):
        """get number of genes that are present in context object"""
        compteur = 0
        for gene in self.genes:
            compteur+=1
        return compteur
    def get_figure(self,Color_dictionaries,ax1,count,Size_arrow,global_coloration,fen,col,NAME_appear,ColMan):
        """build a figure from context object depending on options such
        as size arrow, type of coloration, window size hide/show names
        set color of a gene from Coloration manager object"""
        for gene in self.genes:
            values_color = ColMan.Attribute_color(gene,global_coloration,fen,col,NAME_appear,Color_dictionaries)
            inf = gene.start
            sup = gene.end
            length = sup - inf
            color = values_color[0]
            alpha_col = values_color[1]
            val_x = values_color[2]
            length_x = values_color[3]
            nom_printed = values_color[4]
            color_name = values_color[5]
            ax1.add_patch(
                patches.Arrow(
                    val_x,            # x
                    -1300-(2300*int(count)),            # y
                    int(length_x),            # dx
                    0,            # dy
                    width=int(Size_arrow),
                    facecolor=str(color),
                    alpha=float(alpha_col),
                    edgecolor="black"
                )
            )
            if NAME_appear is True:
                med = inf + length*1/float(2)
                try:
                    if nom_printed in ["","_"] and LOCTAG_appear is True:
                        nom_printed = gene.loctag
                        if nom_printed != "NA":
                            taille = int(12.423*math.exp(-0.065564*len(nom_printed)))
                            ax1.text(med,-((500)*1/float(len(nom_printed)+1)*sqrt(len(nom_printed)+1))-(2300*count), nom_printed, size=taille, rotation=45,color=color_name)
                    else:
                        if nom_printed == "_":
                            nom_printed = ""
                        nom_printed = nom_printed[0].lower()+nom_printed[1:6]
                        ax1.text(med,-((500)*1/float(len(nom_printed)+1)*sqrt(len(nom_printed)+1))-(2300*count), nom_printed[0:6], size=10, rotation=45,color=color_name)
                    # print nom_printed

                except:
                    continue

    def get_iTOL_ligne(self,Color_dictionaries,global_coloration,fen,col,NAME_appear,ColMan):
        """build a text line from context object in iTOl format"""
        context_ligne = ""
        for gene in self.genes:
            values_color = ColMan.Attribute_color(gene,global_coloration,fen,col,NAME_appear,Color_dictionaries)
            inf = gene.start
            sup = gene.end
            sens = gene.strand
            color = values_color[0]
            nom_printed = values_color[4]
            if nom_printed == "" or nom_printed == "_":
                nom_printed = " "
            if sens == "+":
                sens = "TR"
            else:
                sens = "TL"
            if color == "white":
                color = "gray"
            if NAME_appear is True:
                context_ligne += ","+sens+"|"+str(inf)+"|"+str(sup)+"|"+color+"|"+nom_printed
            else:
                context_ligne += ","+sens+"|"+str(inf)+"|"+str(sup)+"|"+color+"| "
        return context_ligne


def parse_gff_line(line):
    """parse gfm line to extract informations about genes"""
    gff_pattern = ""
    if len(line.split("\t"))==7:
        gff_pattern = re.compile(r"^(?P<start>\d+)\t(?P<end>\d+)\t(?P<strand>[+-])\t(?P<wp>.+)\t(?P<loctag>.+)\t(?P<annot>.+)\t(?P<name>.+)")
    else:
        gff_pattern = re.compile(r"^(?P<start>\d+)\t(?P<end>\d+)\t(?P<strand>[+-])\t(?P<wp>.+)\t(?P<loctag>.+)\t(?P<annot>.+)")
    m = gff_pattern.match(line)
    try:
        start = int(m.group('start'))
        end = int(m.group('end'))
        strand = m.group('strand')
        wp = m.group('wp')
        loctag = m.group('loctag')
        annot = m.group('annot')
        try:
            name = m.group('name')
        except:
            return({'start':start, 'end':end, 'strand':strand,'wp':wp,'loctag':loctag, 'annot':annot})
        return({'start':start, 'end':end, 'strand':strand,'wp':wp,'loctag':loctag, 'annot':annot,'name':name})
    except:
        return "WARNING : problem in line "+line

def read_gfm_line(gfm, wp, fen, gca,spec,spec_c,expansion):
    """creates a context object composed of genes
    from gfm lines"""

    WARNING = []
    informations_gene = ""
    genes = []
    if os.path.isfile(gfm) is True:
        gfmr = readfile(gfm)

        moy = 0
        sens = ""
        contig = ""

        wp_test = re.sub(r"\..", "", wp)
        for l in gfmr:
            if re.search(r"^#",l) is None:
                if l.find("\t"+wp_test)!=-1:
                    moy = (int(l.split("\t")[1])+int(l.split("\t")[0]))/float(2)
                    sens = l.split("\t")[2]
                    break
            else:
                contig = re.sub("#", "", l.rstrip())

        if sens == "" and moy == 0:
            WARNING.append("WARNING: "+gfm+" "+wp+" : Accession number not found\n")
            return WARNING
        else:
            borne_inf = moy-fen
            borne_sup = moy+fen
            liste_seq = []
            test_contig = 0

            for l in gfmr:
                if re.search(r"^#",l) is not None:
                    if l.find(contig)!=-1:
                        test_contig += 1
                    else:
                        test_contig =0
                    continue
                if re.search(r"^#",l) is None and test_contig == 1:
                    try:
                        inf = int(l.split("\t")[0])
                        sup = int(l.split("\t")[1])
                        if sup > borne_inf and inf < borne_sup:
                                liste_seq.append(l.rstrip())
                    except:
                        WARNING.append("WARNING: "+gfm+" : No position value detected\n")
                        continue
            if sens == "+":
                for i in liste_seq:
                    gff_data = parse_gff_line(i)
                    if type(gff_data) != str:
                        try:
                            gene = Gene(gff_data['start'], gff_data['end'], gff_data['strand'],gff_data['wp'],gff_data['loctag'],gff_data['annot'],gff_data['name'])
                        except:
                            gene = Gene(gff_data['start'], gff_data['end'], gff_data['strand'],gff_data['wp'],gff_data['loctag'],gff_data['annot'],"")
                    else:
                        WARNING.append(gff_data+" in "+gfm+"\n")
                        continue
                    inf = gene.start
                    sup = gene.end
                    inf_new = int(inf-borne_inf)
                    sup_new = int(sup-borne_inf)
                    if inf_new < 0:
                        inf_new = 0
                    if sup_new > 2*fen:
                        sup_new = 2*fen

                    gene.start = inf_new
                    gene.end = sup_new
                    if gene.name != "":
                        genes.append(gene)
                    else:
                        try:
                            hyponame = tab[5].split(" ").pop()
                            if hyponame[-1].isupper() is True and len(hyponame) >= 3:
                                gene.name = hyponame
                                genes.append(gene)
                            else:
                                genes.append(gene)
                        except:
                            genes.append(gene)
                ##### si ddécalé dans les négatifs
                test_edge = 0
                ecart_inf = 0
                ecart_sup = 0
                for gene in genes:
                    if wp_test == re.sub(r"\..","",gene.wp):
                        if gene.start > fen:
                            ecart_sup = (gene.start+gene.end/2)-fen
                            test_edge += 1
                            break
                        if fen > gene.end:
                            ecart_inf = fen - ((gene.start+gene.end)/2)
                            test_edge += 1
                            break
                        if gene.start <= fen and fen <= gene.end:
                            break
                if test_edge == 1:
                    genes2 = []
                    if ecart_inf == 0:
                        for gene in genes:
                            gene.start = gene.start-ecart_sup
                            gene.end = gene.end-ecart_sup
                    if ecart_sup == 0:
                        for i in gene:
                            tab = i.split("\t")
                            gene.start = gene.start+ecart_inf
                            gene.end = gene.end+ecart_inf
                    genes = []
                    genes = genes2[:]
            if sens == "-":
                for i in reversed(liste_seq):
                    gff_data = parse_gff_line(i)
                    if type(gff_data) != str:
                        try:
                            gene = Gene(gff_data['start'], gff_data['end'], gff_data['strand'],gff_data['wp'],gff_data['loctag'],gff_data['annot'],gff_data['name'])
                        except:
                            gene = Gene(gff_data['start'], gff_data['end'], gff_data['strand'],gff_data['wp'],gff_data['loctag'],gff_data['annot'],"")
                    else:
                        WARNING.append(gff_data+" in "+gfm+"\n")
                        continue
                    inf = gene.start
                    sup = gene.end
                    sens_new = ""
                    if gene.strand == "+":
                        gene.strand = "-"
                    else:
                        gene.strand = "+"
                    sup_new = int((inf + (2*(moy-inf)))-borne_inf)
                    inf_new = int((sup + (2*(moy-sup)))-borne_inf)
                    if inf_new < 0:
                        inf_new = 0
                    if sup_new > 2*fen:
                        sup_new = 2*fen
                    gene.start = inf_new
                    gene.end = sup_new
                    if gene.name != "":
                        genes.append(gene)
                    else:
                        try:
                            hyponame = tab[5].split(" ").pop()
                            if hyponame[-1].isupper() is True and len(hyponame) >= 3:
                                gene.name = hyponame
                                genes.append(gene)
                            else:
                                genes.append(gene)
                        except:
                            genes.append(gene)

                ##### si ddécalé dans les négatifs
                test_edge = 0
                ecart_inf = 0
                ecart_sup = 0
                for i in reversed(genes):
                    if wp_test == re.sub(r"\..","",gene.wp):
                        if gene.start > fen:
                            ecart_sup = (gene.start+gene.end/2)-fen
                            test_edge += 1
                            break
                        if fen > gene.end:
                            ecart_inf = fen - ((gene.start+gene.end)/2)
                            test_edge += 1
                            break
                        if gene.start <= fen and fen <= gene.end:
                            break
                if test_edge == 1:
                    genes2 = []
                    if ecart_inf == 0:
                        for gene in genes:
                            gene.start = gene.start-ecart_sup
                            gene.end = gene.end-ecart_sup
                    if ecart_sup == 0:
                        for i in gene:
                            tab = i.split("\t")
                            gene.start = gene.start+ecart_inf
                            gene.end = gene.end+ecart_inf
                    genes = []
                    genes = genes2[:]
            context = Context(gca,wp,contig,spec,spec_c,0)

            for gene in genes:
                gene.start = gene.start*expansion
                gene.end = gene.end*expansion
                context.add_gene(gene)
            genes  = []
            return context,WARNING
    else:
        WARNING.append("WARNING: "+gfm+" not found\n")
        return WARNING


def readfile(filex):
    """read a file"""
    filex = filex.replace("\t","\\t")
    f = open(filex, "r")
    cont = f.readlines()
    f.close()
    return cont


def ReadInputContext(input_list):
    """tests format of input data"""
    WARNING = []
    tab_output = []
    for l in input_list:
        try:
            if l != "":
                if l.split("\t")[1]!="NA" and l.split("\t")[1]!="pseudogene":
                    tab_output.append(l.split("\t")[0]+"#"+l.split("\t")[1].rstrip())
                else:
                    WARNING.append("WARNING: pseudogene and NA annotations can't be localised\n")
        except:
            try:
                from GeneSpy_tools import Convert_IDs
                tab_output.append(Convert_IDs(l))
            except:
                WARNING.append("WARNING: "+l+" not properly formatted\n")
    return tab_output, WARNING



def Read_Infiles(genes_selection,path_of_path,sort,data_set,monomulti_x):
    """tests what type of data input is, tests if format is ok
    tests if at least one data is ok, select all organisms that
    are implicated, build a dictionnary for it, tests if ids are
    present in database"""
    WARNING = []
    tab_genes = []
    tab_input = []
    if genes_selection == "":
        return [], {}, {}, WARNING,0
    else:
        if data_set == "file":
            try:
                tab_input = readfile(genes_selection)
            except:
                tab_input = genes_selection.split("\n")
                data_set = "sele"
        elif data_set == "sele":
            tab_input = genes_selection.split("\n")
        if len(tab_input) > 0:
            Input_content = ReadInputContext(tab_input)
            tab_genes = Input_content[0]
            WARNING = Input_content[1]
            if len(WARNING) > 0:
                if WARNING[0] == "ERROR":
                    WARNING = []
                    if data_set == "file":
                        WARNING.append("ERROR: infile "+genes_selection+" is not formatted correctly : <Assembly>\\t<Accession>\n")
                    else:
                        WARNING.append("ERROR: Selection is not formatted correctly : <Assembly>\\t<Accession>\n")
                    return [], {}, {}, WARNING,0

        if len(tab_genes) < 1:
            WARNING.append("ERROR: No valid identifier found\n")
            return [], {}, {}, WARNING,0
        n_seq = len(tab_genes)
        liste_spec_tot = []
        dico_spec = {}
        dico_spec_clean = {}
        tab_genes_temp = []
        try:
            liste_spec_tot = readfile(path_of_path[0])#### liste de correspondance assemblage espece#### PATH[0]
        except:
            WARNING.append("ERROR: Strains list "+path_of_path[0]+" not found, please inform GeneSpy the path of Stains list.\n")
            return [], {}, {}, WARNING,0

        for j2, l2 in enumerate(tab_genes):
            compteurspec = 0
            for species in liste_spec_tot:
                tab = species.split("\t")
                if len(tab) != 3:
                    WARNING.append("ERROR: Infile "+path_of_path[0]+" is not formatted correctly : <Assembly>\\t<Real name>\\t<Formatted name>\n")
                    return [], {}, {}, WARNING,0
                if l2.split("#")[0] == tab[0]:# TODO : voir si faut pas garder les GCA_
                    try:
                        dico_spec[tab[0]] = tab[1] ##### dico_spec[Assemblage] = Nom d'espece
                        dico_spec_clean[tab[0]] = tab[2]
                        compteurspec += 1
                        break
                    except:
                        WARNING.append("ERROR: Infile "+path_of_path[0]+" is not formatted correctly : <Assembly>\\t<Real name>\\t<Formatted name>\n")
                        return [], {}, {}, WARNING,0
            if compteurspec == 0:
                WARNING.append("WARNING: "+l2.split("#")[0]+" not found in "+path_of_path[0]+"\n")
            else:
                tab_genes_temp.append(l2)
        tab_genes = tab_genes_temp[:]
        tab_genes_temp = []
        if sort == "alpha":
            for i in sorted(tab_genes, key=lambda t:dico_spec[t.split("#")[0]]):
                tab_genes_temp.append(i)
            tab_genes = []
            tab_genes = tab_genes_temp[:]
        compteur = 0
        if len(tab_genes) == 0:
            WARNING.append("ERROR: No valid identifier found\n")
        if len(tab_genes) > 330 and monomulti_x == "multi":
            WARNING.append("WARNING: Too many sequences, selecting first 330 sequences : "+str(len(tab_genes))+" sequences\n")
            #WARNING.append("WARNING: 330 sequences are displayed in the interface but if exported, all sequences are displayed\n")



        return tab_genes, dico_spec, dico_spec_clean, WARNING,n_seq

def Find_Context(tab_genes,fen,path,dico_spec,dico_spec_clean,expansion,monomulti_x):
    """build contexts from brut data"""
    list_contexts = []
    dico_final0 = {}
    # tab_genes2 = []
    compteur = -1
    WARNING = []
    for gene in tab_genes:
        #print tab_genes
        #print gene
        if compteur == 330 and monomulti_x == "multi":
            break
        gca = gene.split("#")[0]
        wp = gene.split("#")[1]
        gfm = path[1]+gca+".gfm" ##### path des fichiers gfm
        # content_read_gfm = ()
        # try:
        spec = dico_spec[gca]
        spec_c = dico_spec_clean[gca]
        content_read_gfm = read_gfm_line(gfm,wp,fen,gca,spec,spec_c,expansion)
        if len(content_read_gfm) == 2:
            WARNING.extend(content_read_gfm[1])
            if content_read_gfm[0].test_len() > 0:
                compteur += 1
                content_read_gfm[0].target_spec_c = spec_c.rstrip()
                content_read_gfm[0].target_spec = spec
                content_read_gfm[0].target_index = compteur
                list_contexts.append(content_read_gfm[0])
        else:
            # print content_read_gfm[0]
            WARNING.extend(content_read_gfm)


    return list_contexts,WARNING


def Figure_Maker(path_anfile,list_contexts,dico_spec,fen,col,formats,infile,monomulti,name_output_file,frame_x):
    """build figures"""
    global WP_appear
    global CONTIG_appear
    global Size_arrow
    global WARNING_g
    global WARNING_tot
    global NAME_appear
    global ColMan
    global T2
    name_length = len(max(dico_spec.values(), key=lambda t: len(t)))
    Color_dictionaries =  ColMan.Files_Color(path_anfile,list_contexts)
    if monomulti.find("ITOL")==-1:
        ProgressW= Toplevel() ##
        ProgressW.wm_title("Loading data ...") ##
        fig_t = StringVar() ##
        progress=ttk.Progressbar(ProgressW,orient=HORIZONTAL,length=100,mode='determinate') ##
        progress.config(maximum=100)
        progress.grid(row=0,column=0,sticky=N+E+W+S) ##
        pol = tkFont.Font(family='Courrier', size=8, weight=tkFont.BOLD)
        FileTreated = Label(ProgressW,textvariable=fig_t, bg="#b2b2b2", width=70, height=5,font=pol, bd=5 ).grid(row=1,column=0,sticky=N+E+W+S) ##
        # content_scale = get_scale(PATH)
        scale = 0.0000412108337
        # if len(content_scale[1]) != 0:
        #     WARNING_g.extend(content_scale[1])
        count = -1
        count_order = -1
        liste_fig = []
        fig1 = Figure()
        scale_name = 0
        ax1 = ""
        if monomulti == "mono":
            fig1 = Figure(figsize=((name_length/float(8.5-scale*fen)+(0.0008603333*fen)),len(list_contexts)))
            scale_name = 0.0035
            ax1 = fig1.add_subplot(111, aspect='equal',ylim=[-2000*len(list_contexts)*1.20,300],xlim=[-(name_length/float(scale_name))-1400,2*fen+300])
        else:
            scale_name = 0.0035
        for n,contexte in enumerate(list_contexts):
            fig_t.set(contexte.target_wp) ##
            ProgressW.update_idletasks() ##
            count_order += 1
            if monomulti == "multi":
                count = 0
                fig1 = Figure(figsize=((name_length/float(8.5-scale*fen)+(0.0008603333*fen)),1))
                ax1 = fig1.add_subplot(111, aspect='equal',ylim=[-2000,300],xlim=[-(name_length/float(scale_name))-1400,2*fen])
            if monomulti == "mono":
                count += 1
            fig1.patch.set_facecolor('white')
            fig1.subplots_adjust(left=0.0, right=1.0, bottom=0.0, top=1.0)
            ax1.axes.get_yaxis().set_visible(False)
            ax1.axes.get_xaxis().set_visible(False)
            ax1.set_axis_off()
            contexte.get_figure(Color_dictionaries,ax1,count,Size_arrow,global_coloration,fen,col,NAME_appear,ColMan)
            if WP_appear is True or CONTIG_appear is True:
                ax1.text(-(name_length/float(scale_name))-700,-600-(2300*count),contexte.target_spec, size=13,fontweight='bold',fontname='monospace')
            else:
                ax1.text(-(name_length/float(scale_name))-700,-1500-(2300*count),contexte.target_spec, size=13,fontweight='bold',fontname='monospace')
            if WP_appear is True:
                ax1.text(-(name_length/float(scale_name))-700,-1000-(2300*count),contexte.target_wp+" ("+contexte.target_gca+")", size=10)
            if CONTIG_appear is True:
                ax1.text(-(name_length/float(scale_name))-700,-1400-(2300*count),contexte.target_contig, size=10)
            if monomulti =="multi":
                liste_fig_g.append(fig1)
            contexte.target_index = count_order
            progress['value']=int((n+1)/float(len(list_contexts))*100) ##
            progress.update() ##
        if monomulti == "mono":
            Canvas1 = FigureCanvasTkAgg(fig1, master=root)
            # print type name_output_file
            # print unicode(name_output_file,'utf-8')
            # print unicode(name_output_file,'utf-8').decode('utf-8')
            # print unicode(name_output_file,'utf-8').decode('utf-8').encode('latin1')
            try:
                Canvas1.print_figure(name_output_file,edgecolor=None,format=formats)
                Canvas1.get_tk_widget().delete("all")
                liste_wid_root = root.winfo_children()
                plt.close(fig1)
                fig1.clf()
                fig1.clear()
                liste_wid_root[-1].grid_forget()
                liste_wid_root[-1].destroy()
                del Canvas1
            except:
                T2.insert(END,"ERROR: Too many contexts to export in image!\n")
                T2.tag_add('err', str(WARNING_tot)+'.0', str(WARNING_tot+1)+'.0')
                T2.tag_config('err', foreground='red')
                T2.see(END)
                WARNING_tot += 1
                Canvas1.get_tk_widget().delete("all")
                liste_wid_root = root.winfo_children()
                plt.close(fig1)
                fig1.clf()
                fig1.clear()
                liste_wid_root[-1].grid_forget()
                liste_wid_root[-1].destroy()
                del Canvas1
                ProgressW.destroy()
                return 0
            T2.insert(END,"INFO: "+formats+" saved as : "+name_output_file+"\n")
            T2.tag_add('infoexp', str(WARNING_tot)+'.0', str(WARNING_tot+1)+'.0')
            T2.tag_config('infoexp', foreground='black')
            T2.see(END)
            WARNING_tot += 1
        ProgressW.destroy()
    else:
        itol = []
        itol.append("DATASET_DOMAINS\nSEPARATOR COMMA\nDATASET_LABEL,Genomic Context\nDATA\n")
        if monomulti == "ITOL1":
            for n,contexte in enumerate(list_contexts):
                l = ""
                l += re.sub(">", "", contexte.target_gca+","+str(2*fen))
                l += contexte.get_iTOL_ligne(Color_dictionaries,global_coloration,fen,col,NAME_appear,ColMan)
                itol.append(l+"\n")
        elif monomulti == "ITOL1WP":
            for n,contexte in enumerate(list_contexts):
                l = ""
                l += re.sub(">", "", contexte.target_gca+"_"+contexte.target_wp+","+str(2*fen))
                l += contexte.get_iTOL_ligne(Color_dictionaries,global_coloration,fen,col,NAME_appear,ColMan)
                itol.append(l+"\n")
        elif monomulti == "ITOL2":
            for n,contexte in enumerate(list_contexts):
                l = ""
                l += re.sub(">", "", contexte.target_spec_c+","+str(2*fen))
                l += contexte.get_iTOL_ligne(Color_dictionaries,global_coloration,fen,col,NAME_appear,ColMan)
                itol.append(l+"\n")
        elif monomulti == "ITOL2WP":
            for n,contexte in enumerate(list_contexts):
                l = ""
                l += re.sub(">", "", contexte.target_spec_c+"_"+contexte.target_wp+","+str(2*fen))
                l += contexte.get_iTOL_ligne(Color_dictionaries,global_coloration,fen,col,NAME_appear,ColMan)
                itol.append(l+"\n")
        out_itol = open(name_output_file,"w")
        [out_itol.write(i) for i in itol]
        out_itol.close()
        if len(itol)!=0:
            T2.insert(END,"INFO: iTOL color file saved as : "+name_output_file+"\n")
            T2.tag_add('info', str(WARNING_tot)+'.0', str(WARNING_tot+1)+'.0')
            #WARNING.append("info")
            T2.tag_config('info', foreground='black')
            T2.see(END)
            WARNING_tot += 1
    return name_length
def Crash():
    """crash genespy if memory too high"""
    sys.exit()

compteur_general = 0
def memory_test(path_anfile,threshold,threshold_last,n_seq):
    """tests memory use"""
    global compteur_general
    compteur_general += 1*n_seq
    if compteur_general > int(threshold_last):
        Temp_dataw = open(path_anfile+"Temp_data.txt", "w")
        Temp_dataw.write(sort_g+"\n"+str(fen_g)+"\n"+col_g+"\n"+data_set_g+"\n"+str(WP_appear)+"\n"+str(CONTIG_appear)+"\n"+str(Size_arrow)+"\n"+global_coloration+"\n"+str(compteur_general)+"\n"+str(NAME_appear)+"\n"+file_color_g+"\n"+str(expansion_g)+"\n"+str(LOCTAG_appear)+"\n"+str(path_infile_g))
        Temp_dataw.close()
        info = tkMessageBox.showinfo("Imminent Crash", "!!! Excess of memory !!! \nGeneSpy will crash, your data will be saved\n just restart GeneSpy to relaunch your data")
        Crash()
    if compteur_general > threshold:
        Temp_dataw = open(path_anfile+"Temp_data.txt", "w")
        Temp_dataw.write(sort_g+"\n"+str(fen_g)+"\n"+col_g+"\n"+data_set_g+"\n"+str(WP_appear)+"\n"+str(CONTIG_appear)+"\n"+str(Size_arrow)+"\n"+global_coloration+"\n"+str(threshold)+"\n"+str(NAME_appear)+"\n"+file_color_g+"\n"+str(expansion_g)+"\n"+str(LOCTAG_appear)+"\n"+str(path_infile_g))
        Temp_dataw.close()
        clearall()
        import os
        import sys
        import gc
        gc.collect()
        #os.execv(sys.executable, [ os.path.realpath(sys.argv[0])])
        os.execv(sys.executable, ['python']+sys.argv)
def clearall() :
    """clear all python environment variables"""
    all = [var for var in globals() if var[0] != "_"]
    for var in all:
        del globals()[var]
def Context_Launcher(path_infile,root,formats,monomulti):
    """launch pipeline to build figures"""

    if path_infile != "":
        global T2
        global WARNING_g
        global dico_spec_clean_g
        global list_contexts_g
        global liste_fig_g
        global path_anfile_g
        global dico_spec_g
        global tab_genes2_g
        global PATH
        global sort_g
        global fen_g
        global col_g
        global n_seq_g
        global frame
        global name_length_g
        global liste_wid
        global WARNING_tot
        global data_set_g
        global tab_genes_g
        global threshold_memory
        global expansion_g
        name_output_file = ""
        elements  = path_infile.split("\\")
        filex = elements.pop()
        folder = "\\".join(elements)

        if monomulti == "mono":
            if formats == "png":
                filename_s = asksaveasfilename(initialdir=folder,filetypes = [("png file","*.png")],title="Export png format")
                try:
                    name_output_file = filename_s.encode("cp1252")
                except:
                    return ""
            if formats == "pdf":
                filename_s = asksaveasfilename(initialdir=folder,filetypes = [("pdf file","*.pdf")],title="Export pdf format")
                try:
                    name_output_file = filename_s.encode("cp1252")
                except:
                    return ""
            if formats == "svg":
                filename_s = asksaveasfilename(initialdir=folder,filetypes = [("svg file","*.svg")],title="Export svg format")
                try:
                    name_output_file = filename_s.encode("cp1252")
                except:
                    return ""
        if monomulti == "ITOL1":
            formats = "txt"
            filename_s = asksaveasfilename(initialdir=folder,filetypes = [("Text file","*.txt")],title="Export iTOL format (list IDs)")
            try:
                name_output_file = filename_s.encode("cp1252")
            except:
                return ""
            Confirmation = tkMessageBox.askyesno("Display accession numbers","Do you want to display accession number (<assembly>_<accession>)?")
            if Confirmation is True:
                monomulti = "ITOL1WP"
        if monomulti == "ITOL2":
            formats = "txt"
            filename_s = asksaveasfilename(initialdir=folder,filetypes = [("Text file","*.txt")],title="Export iTOL format (formatted IDs)")
            try:
                name_output_file = filename_s.encode("cp1252")
            except:
                return ""
            Confirmation = tkMessageBox.askyesno("Display accession numbers","Do you want to display accession number (<formatted name>_<accession>)?")
            if Confirmation is True:
                monomulti = "ITOL2WP"
        if (name_output_file == "" or name_output_file == "None") and (monomulti == "mono" or monomulti.find("ITOL")!=-1):
            print "",
        else:
            name_output_file = name_output_file.replace("/","\\").replace("."+formats,"")
            if formats == "png":
                name_output_file += ".png"
            if formats == "pdf":
                name_output_file += ".pdf"
            if formats == "svg":
                name_output_file += ".svg"
            if monomulti.find("ITOL")!=-1:
                name_output_file += ".txt"
            root.config(cursor="watch")
            root.update()
            if monomulti == "multi":
                Clean_Canvas()
            content_read = Read_Infiles(path_infile, PATH, sort_g, data_set_g,monomulti)
            tab_genes_g = content_read[0]
            dico_spec_g = content_read[1]
            dico_spec_clean_g = content_read[2]
            WARNING_g.extend(content_read[3])
            n_seq_g = content_read[4]
            if monomulti == "multi":
                memory_test(path_anfile_g,threshold_memory,PATH[5],n_seq_g)
            ERROR = 0
            for i,j in enumerate(WARNING_g):
                if j.find("ERROR")!=-1:
                    T2.insert(END,j)
                    T2.tag_add('ERROR',  str(WARNING_tot)+'.0', str(WARNING_tot+1)+'.0')
                    T2.tag_config('ERROR', foreground='red')
                    T2.see(END)
                    WARNING_tot += 1
                    ERROR += 1
                else:
                    T2.insert(END,j)
                    T2.tag_add('WARNING',  str(WARNING_tot)+'.0', str(WARNING_tot+1)+'.0')
                    T2.tag_config('WARNING', foreground='darkorange2')
                    T2.see(END)
                    WARNING_tot += 1
            WARNING_g = []
            if ERROR == 0 and len(tab_genes_g) > 0:
                content_find = Find_Context(tab_genes_g,fen_g,PATH,dico_spec_g,dico_spec_clean_g,expansion_g,monomulti)
                list_contexts_g= content_find[0]
                WARNING_g.extend(content_find[1])
                fen_g = fen_g *expansion_g
                if monomulti == "multi":
                    name_length_g = Figure_Maker(path_anfile_g,list_contexts_g,dico_spec_g,fen_g,col_g,formats,path_infile,monomulti,name_output_file,"")
                    liste_wid = Print_Figures(liste_fig_g,frame,n_seq_g)
                else:
                    content_figure = Figure_Maker(path_anfile_g,list_contexts_g,dico_spec_g,fen_g,col_g,formats,path_infile,monomulti,name_output_file,frame)
                for i,j in enumerate(WARNING_g):
                    T2.insert(END,j)
                    T2.tag_add('WARNING',  str(WARNING_tot)+'.0', str(WARNING_tot+1)+'.0')
                    T2.tag_config('WARNING', foreground='darkorange2')
                    T2.see(END)
                    WARNING_tot += 1
                WARNING_g = []
                if len(list_contexts_g) == 0:
                    T2.insert(END,"ERROR: No valid identifer has been found\n")
                    T2.tag_add('ERROR',  str(WARNING_tot)+'.0', str(WARNING_tot+1)+'.0')
                    T2.tag_config('ERROR', foreground='red')
                    T2.see(END)
                    WARNING_tot += 1
                    WARNING_g = []
            if len(list_contexts_g) != 0 and monomulti == "multi":
                if path_infile.find("\t")!=-1:
                    root.wm_title("GeneSpy -- Selection")
                else:
                    root.wm_title("GeneSpy -- "+path_infile)
        for i in liste_wid:
            i.bind('<MouseWheel>', on_mousewheel)
        root.config(cursor="")
        root.update()
        fen_g = fen_g/expansion_g


def Clean_Canvas():
    """Clean canvas and figures to decrease memory use"""
    global liste_wid
    global liste_fig_g
    global frame
    global fond
    global liste_canvas
    ProgressW= Toplevel() ##
    ProgressW.wm_title("Erasing figures ...") ##
    fig_t = StringVar() ##
    progress=ttk.Progressbar(ProgressW,orient=HORIZONTAL,length=100,mode='determinate') ##
    progress.config(maximum=100)
    progress.grid(row=0,column=0,sticky=N+E+W+S) ##
    pol = tkFont.Font(family='Courrier', size=8, weight=tkFont.BOLD)
    FileTreated = Label(ProgressW,textvariable=fig_t, bg="#b2b2b2", width=70, height=5,font=pol, bd=5 ).grid(row=1,column=0,sticky=N+E+W+S) ##
    for n,i in enumerate(liste_wid):
        i.grid_forget()
        i.destroy()
        fig_t.set(str(n)+"/"+str(len(liste_wid))) ##
        ProgressW.update_idletasks() ##
        progress['value']=int((n+1)/float(len(liste_wid))*100) ##
        progress.update() ##
    ProgressW.destroy()
    for i in liste_canvas:
        i.get_tk_widget().delete("all")
    liste_wid = []
    liste_canvas = []
    for j,i in enumerate(liste_fig_g):
        plt.close(i)
        i.clf()
        i.clear()
    liste_fig_g = []
    liste_wid = frame.winfo_children()

    del liste_fig_g[:]
    liste_fig_g = []
    gc.collect()

################################################################################
def Print_Figures(liste_fig,frame_x,n_seq):
    """display figures in tkinter"""
    if n_seq <=330:
        for i in range(n_seq):
            try:
                canvas = FigureCanvasTkAgg(liste_fig[i], master=frame_x)
                canvas.get_tk_widget().configure(background='white',highlightbackground='gray')
                canvas.get_tk_widget().grid(row=i,column=1)
            except:
                continue
    else:
        for i in range(330):
            try:
                canvas = FigureCanvasTkAgg(liste_fig[i], master=frame_x)
                canvas.get_tk_widget().grid(row=i,column=1)

            except:
                continue
    global scrollbary
    global scrollbarx
    global fond
    ############ attacheleent des scrollbar sur le canvas
    scrollbary.config(command=fond.yview)
    scrollbarx.config(command=fond.xview)
    ######### empecher le canvas de se resizer
    frame_x.update_idletasks()
    fond.config(scrollregion=fond.bbox("all"))
    liste_wid_x = frame_x.winfo_children()
    return liste_wid_x

################################################################################


################################################################################
# def get_scale(PATH):
#     """set scale of figures depending on os and versions"""
#     WARNING = []
#     scale = 0
#     if platform.system() == "Linux":
#         try:
#             infos = list(platform.linux_distribution()[:])
#             version = int(re.sub("\'", "", infos[1]).split(".")[0])
#             if version == 12:
#                 scale = 0.0000412108337
#             if version == 14:
#                 scale = 0.0000412108337
#             if version == 15:
#                 scale = 0.0000412108337
#             if version == 16:
#                 scale = 0.0000112108337
#             if scale == 0:
#                 scale = float(PATH[2].rstrip())
#                 if PATH[3] != "OK":
#                     WARNING.append("WARNING: version of Linux is maybe not compatible with scale. Please change scale factor in PATHS_PARAMS.ini if problems append in figure scale\n")
#         except:
#             scale = float(PATH[2].rstrip())
#             if PATH[3] != "OK":
#                 WARNING.append("WARNING: version of Linux is maybe not compatible with scale. Please change scale factor in PATHS_PARAMS.ini if problems append in figure scale\n")
#     else:
#         scale = float(PATH[2].rstrip())
#         if PATH[3] != "OK":
#             WARNING.append("WARNING: OS not compatible with default scale factor. Please change scale factor in PATHS_PARAMS.ini if problems append in figure scale\n")
#     return scale,WARNING
#

################################################################################
def callback(event):
    """get annotation of any gene"""
    global name_length_g
    global list_contexts_g
    global ann
    global fen_g
    global liste_wid
    global expansion_g
    x =  event.x
    y = event.y
    cid = event.widget
    identifierx = ""
    try:
        if 40 < y and y < 90:
            length_canvas = cid.winfo_width()
            length_window = (name_length_g/float(0.0035))+1400+2*fen_g*expansion_g
            # print fen_g,expansion_g
            index = liste_wid.index(cid)
            pos_point = (x*length_window)/float(length_canvas)-((name_length_g/float(0.0035))+1400)
            tab_ind = list_contexts_g[index].genes
            for gene in tab_ind:
                inf = gene.start
                sup =gene.end
                if int(inf) < pos_point and pos_point < int(sup):
                    wpx = gene.wp
                    loctx = gene.loctag
                    annotx = gene.annot
                    texte = "Accession number : "+wpx+"\nLocus tag : "+loctx+"\nFunction : "+annotx
                    ann.set(texte)
    except:
        print "",

################################################################################
def callback2(event):
    """get ids of your gene"""
    global T
    x =  event.x
    y = event.y
    cid = event.widget
    try:
        length_canvas = cid.winfo_width()
        index = liste_wid.index(cid)
        identifierx = list_contexts_g[index].target_gca+"\t"+list_contexts_g[index].target_wp+"\t#Target gene\n"
        T.insert(END, identifierx)
        T.see(END)
    except:
        print "",

################################################################################

def callback3(event):
    """get ids of any gene"""
    global name_length_g
    global list_contexts_g
    global T
    global fen_g
    global expansion_g
    x =  event.x
    y = event.y
    cid = event.widget
    try:
        if 40 < y and y < 90:
            length_canvas = cid.winfo_width()
            length_window = (name_length_g/float(0.0035))+1400+2*fen_g*expansion_g
            index = liste_wid.index(cid)
            pos_point = (x*length_window)/float(length_canvas)-((name_length_g/float(0.0035))+1400)
            tab_ind = list_contexts_g[index].genes
            for gene in tab_ind:
                inf = gene.start
                sup = gene.end
                if int(inf) < pos_point and pos_point < int(sup):
                    wpx = gene.wp
                    annotx = gene.annot
                    texte = list_contexts_g[index].target_gca+"\t"+wpx+"\t#"+annotx+"\n"
                    T.insert(END, texte)
                    T.see(END)
    except:
        print "",


def callback4(event):
    try:
        lien = "https://www.ncbi.nlm.nih.gov/protein/"+event.widget.cget("text").split("\n")[0].split(":")[1].replace(" ","")
        webbrowser.open(lien,new=2)
    except:
        return ""
################################################################################
##### bouton fermer
def close_window(root):
    """close window"""
    root.destroy()
    root.quit()

################################################################################
#### export pdf
def multipage(filename,liste_fig,WARNING):
    """export in multi pdf"""
    global root
    global WARNING_tot
    global T2
    elements  = filename.split("\\")
    filex = elements.pop()
    folder = "\\".join(elements)
    filename_s = asksaveasfilename(initialdir=folder,filetypes = [("pdf file","*.pdf")],title="Export pdf format")
    try:
        name_file = filename_s.encode("cp1252")
    except:
        return ""
    if name_file != "None":
        if name_file != "" and name_file != "()":
            name_file = name_file.replace("/","\\").replace(".pdf","")+".pdf"
            root.config(cursor="watch")
            root.update()
            ProgressW= Toplevel() ##
            ProgressW.wm_title("Exporting in multiple pdf...") ##
            file_t = StringVar() ##
            progress=ttk.Progressbar(ProgressW,orient=HORIZONTAL,length=100,mode='determinate') ##
            progress.config(maximum=100)
            progress.grid(row=0,column=0,sticky=N+E+W+S) ##
            pol = tkFont.Font(family='Courrier', size=8, weight=tkFont.BOLD)
            FileTreated = Label(ProgressW,textvariable=file_t, bg="#b2b2b2", width=70, height=5,font=pol, bd=5 ).grid(row=1,column=0,sticky=N+E+W+S) ##

            pp = PdfPages(name_file)
            for n,fig in enumerate(liste_fig):
                file_t.set(list_contexts_g[n].target_wp) ##
                ProgressW.update_idletasks() ##
                try:
                    fig.savefig(pp, format='pdf')
                except:
                    print "",

                progress['value']=int((n+1)/float(len(liste_fig))*100) ##
                ProgressW.update() ##
            if len(liste_fig)!=0:
                T2.insert(END,"INFO: Pdf saved as : "+name_file+"\n")
                T2.tag_add('infopdf', str(WARNING_tot)+'.0', str(WARNING_tot+1)+'.0')
                T2.tag_config('infopdf', foreground='black')
                T2.see(END)
                WARNING_tot += 1
            pp.close()
            ProgressW.destroy() ##
            root.config(cursor="")
            root.update()

def ExportTxt(path_infile,tab_genes):
    """export in txt format"""
    global T2
    global WARNING_tot
    global T
    if len(tab_genes)!=0 or str(T.get("1.0",END)).find("\t")!=-1:
        elements  = path_infile.split("\\")
        filex = elements.pop()
        folder = "\\".join(elements)
        filename_s = asksaveasfilename(initialdir=folder,filetypes = [("txt file","*.txt")],title="Save as")
        try:
            name_output_file = filename_s.encode("cp1252")
        except:
            return ""
        if name_output_file == "" or name_output_file == "None":
            return ""
        else:
            name_output_file = name_output_file.replace("/","\\").replace(".txt","")+".txt"
            out_txt = open(name_output_file,"w")
            if len(tab_genes)!=0:
                for i in tab_genes:
                    out_txt.write(i.replace("#","\t")+"\n")
            else:
                if str(T.get("1.0",END)).find("\t")!=-1:
                    out_txt.write(T.get("1.0",END))
                else:
                    T2.insert(END,"ERROR: invalid format\n")
                    T2.tag_add('errtxt',  str(WARNING_tot)+'.0', str(WARNING_tot+1)+'.0')
                    T2.tag_config('errtxt', foreground='red')
                    T2.see(END)
                    WARNING_tot += 1
                    return ""
            out_txt.close()
            T2.insert(END,"INFO: Identifiers saved as : "+name_output_file+"\n")
            T2.tag_add('inftxt',  str(WARNING_tot)+'.0', str(WARNING_tot+1)+'.0')
            T2.tag_config('inftxt', foreground='black')
            T2.see(END)
            WARNING_tot += 1
################################################################################
def OpenFileMenu(root_x):
    """import a file"""
    global data_set_g
    global path_infile_g
    filename = ""
    if path_infile_g.find("\\")!=-1:
        elements  = path_infile_g.split("\\")
        filex = elements.pop()
        folder = "\\".join(elements)
        try:
            filename = askopenfilename(filetypes = [("txt files","*.txt")],title="Load file",initialdir=folder).encode("cp1252")
        except:
            return ""
    else:
        try:
            filename = askopenfilename(filetypes = [("txt files","*.txt")],title="Load file").encode("cp1252")
        except:
            return ""
    if filename  != "None":
        if str(filename) != "()" and str(filename) != "":
            filename = filename.replace("/","\\")
            path_infile_g = filename
            data_set_g = "file"
            Context_Launcher(filename,root_x,"","multi")
def OpenFileMenuExport(root_x):
    """import a file"""
    global data_set_g
    global path_infile_g
    filename = ""
    folder = ""
    if path_infile_g.find("\\")!=-1:
        elements  = path_infile_g.split("\\")
        filex = elements.pop()
        folder = "\\".join(elements)
        try:
            filename = askopenfilename(filetypes = [("txt files","*.txt")],title="Load file",initialdir=folder).encode("cp1252")
        except:
            return ""
    else:
        try:
            filename = askopenfilename(filetypes = [("txt files","*.txt")],title="Load file").encode("cp1252")
        except:
            return ""
    if filename  != "None":
        if str(filename) != "()" and str(filename) != "":
            path_infile_g = filename
            data_set_g = "file"
            ExpWindow= Toplevel(bg="#454545")
            ExpWindow.wm_title("Export file")
            ExpWindow.configure(background="#454545")
            v = IntVar()
            texte=Label(ExpWindow, text="Choose file type", bg="#454545", width=24, height=1, font=police, bd=5, fg="white").grid(row=0,column=1,sticky=E+W)
            colonne0 =Label(ExpWindow, bg="#454545").grid(row=0,column=0, rowspan=13)
            colonne1 =Label(ExpWindow, bg="#454545").grid(row=0,column=2, rowspan=13)
            sen1  = Radiobutton(ExpWindow, text="SVG", variable=v, value=1, bg="#b2b2b2", indicatoron=0, width=18, height=1)
            sen1.grid(row=1,column=1,sticky=W+E)
            sen2 = Radiobutton(ExpWindow, text="PNG", variable=v, value=2, bg="#b2b2b2", indicatoron=0, width=18, height=1)
            sen2.grid(row=2,column=1,sticky=W+E)
            # sen2 = Radiobutton(ExpWindow, text="JPG", variable=v, value=3, bg="#b2b2b2", indicatoron=0, width=18, height=1)
            # sen2.grid(row=3,column=1,sticky=W+E)
            # sen2 = Radiobutton(ExpWindow, text="EPS", variable=v, value=4, bg="#b2b2b2", indicatoron=0, width=18, height=1)
            # sen2.grid(row=4,column=1,sticky=W+E)
            # sen2 = Radiobutton(ExpWindow, text="TIF", variable=v, value=5, bg="#b2b2b2", indicatoron=0, width=18, height=1)
            # sen2.grid(row=5,column=1,sticky=W+E)
            sen2 = Radiobutton(ExpWindow, text="PDF", variable=v, value=6, bg="#b2b2b2", indicatoron=0, width=18, height=1)
            sen2.grid(row=6,column=1,sticky=W+E)
            # sen2 = Radiobutton(ExpWindow, text="multiple PDF", variable=v, value=7, bg="#b2b2b2", indicatoron=0, width=18, height=1)
            # sen2.grid(row=7,column=1,sticky=W+E)
            sen2 = Radiobutton(ExpWindow, text="iTOL(<Assembly>)", variable=v, value=8, bg="#b2b2b2", indicatoron=0, width=18, height=1)
            sen2.grid(row=8,column=1,sticky=W+E)
            sen2 = Radiobutton(ExpWindow, text="iTOL(<Name>)", variable=v, value=9, bg="#b2b2b2", indicatoron=0, width=18, height=1)
            sen2.grid(row=9,column=1,sticky=W+E)
            run = Button (ExpWindow, text = "OK", command = lambda : LoadExportLaunch(v.get(),ExpWindow,filename,root_x), font=police, bg="#b2b2b2").grid(row=11,column=1,sticky=E+W)


            # print name_out_file

            # Context_Launcher(filename,root_x,"","multi")
def LoadExportLaunch(Val,Window,filename,root_x):
    Window.destroy()
    Clean_Canvas()
    if Val == 1:
        Context_Launcher(filename,root_x,"svg","mono")
    if Val == 2:
        Context_Launcher(filename,root_x,"png","mono")
    if Val == 3:
        Context_Launcher(filename,root_x,"jpg","mono")
    if Val == 4:
        Context_Launcher(filename,root_x,"eps","mono")
    if Val == 5:
        Context_Launcher(filename,root_x,"tif","mono")
    if Val == 6:
        Context_Launcher(filename,root_x,"pdf","mono")
    if Val == 8:
        Context_Launcher(filename,root_x,"","ITOL1")
    if Val == 9:
        Context_Launcher(filename,root_x,"","ITOL2")
################################################################################
def Options(root_x,col,sort,filename):
    """Open otions window"""
    global col_g
    global sort_g
    global fen_g
    global Size_arrow
    global WP_appear
    global CONTIG_appear
    global global_coloration
    global NAME_appear
    global expansion_g
    OptionsWindow= Toplevel()
    OptionsWindow.wm_title("Options")
    # OptionsWindow.attributes("-topmost", True)
    v = IntVar()
    OptionsWindow.configure(background="#454545")
    texte=Label(OptionsWindow, text="Coloration", bg="#454545", width=24, height=1, font=police, bd=5, fg="white").grid(row=0,column=1, columnspan=2,sticky=E+W)
    colonne0 =Label(OptionsWindow, bg="#454545").grid(row=0,column=0, rowspan=13)
    colonne1 =Label(OptionsWindow, bg="#454545").grid(row=0,column=3, rowspan=13)
    sen1  = Radiobutton(OptionsWindow, text="Dull colors for Inferred", variable=v, value=1, bg="#b2b2b2", width=18, height=1)
    sen1.grid(row=1,column=1,sticky=W+E)
    sen2 = Radiobutton(OptionsWindow, text="Equal colors", variable=v, value=2, bg="#b2b2b2", width=18, height=1)
    sen2.grid(row=1,column=2,sticky=W+E)

    v2 = IntVar()
    texte2=Label(OptionsWindow, text="Order", bg="#454545", width=24, height=1, font=police, bd=5, fg="white").grid(row=2,column=1, columnspan=2,sticky=E+W)
    ord1 = Radiobutton(OptionsWindow, text="Initial", variable=v2, value=1, bg="#b2b2b2", width=18, height=1)
    ord1.grid(row=3,column=1,sticky=W+E)
    ord2 = Radiobutton(OptionsWindow, text="Alphabetic", variable=v2, value=2, bg="#b2b2b2", width=18, height=1)
    ord2.grid(row=3,column=2,sticky=W+E)

    v6 = IntVar()
    texte5=Label(OptionsWindow, text="Gene names", bg="#454545", width=24, height=1, font=police, bd=5, fg="white").grid(row=4,column=1, columnspan=2,sticky=E+W)
    nam1 = Radiobutton(OptionsWindow, text="Show", variable=v6, value=1, bg="#b2b2b2", width=18, height=1)
    nam1.grid(row=5,column=1,sticky=W+E)
    nam2 = Radiobutton(OptionsWindow, text="Hide", variable=v6, value=2, bg="#b2b2b2", width=18, height=1)
    nam2.grid(row=5,column=2,sticky=W+E)

    v3 = IntVar()
    texte7=Label(OptionsWindow, text="Accession number", bg="#454545", width=24, height=1, font=police, bd=5, fg="white").grid(row=6,column=1, columnspan=2,sticky=E+W)
    wp1 = Radiobutton(OptionsWindow, text="Show", variable=v3, value=1, bg="#b2b2b2", width=18, height=1)
    wp1.grid(row=7,column=1,sticky=W+E)
    wp2 = Radiobutton(OptionsWindow, text="Hide", variable=v3, value=2, bg="#b2b2b2", width=18, height=1)
    wp2.grid(row=7,column=2,sticky=W+E)

    v4 = IntVar()
    texte5=Label(OptionsWindow, text="Contig", bg="#454545", width=24, height=1, font=police, bd=5, fg="white").grid(row=8,column=1, columnspan=2,sticky=W+E)
    con1 = Radiobutton(OptionsWindow, text="Show", variable=v4, value=1, bg="#b2b2b2", width=18, height=1)
    con1.grid(row=9,column=1,sticky=W+E)
    con2 = Radiobutton(OptionsWindow, text="Hide", variable=v4, value=2, bg="#b2b2b2", width=18, height=1)
    con2.grid(row=9,column=2,sticky=W+E)


    v7 = IntVar()
    texte5=Label(OptionsWindow, text="Locus tag", bg="#454545", width=24, height=1, font=police, bd=5, fg="white").grid(row=10,column=1, columnspan=2,sticky=W+E)
    loc1 = Radiobutton(OptionsWindow, text="Show", variable=v7, value=1, bg="#b2b2b2", width=18, height=1)
    loc1.grid(row=11,column=1,sticky=W+E)
    loc2 = Radiobutton(OptionsWindow, text="Hide", variable=v7, value=2, bg="#b2b2b2", width=18, height=1)
    loc2.grid(row=11,column=2,sticky=W+E)


    texte3 = Label(OptionsWindow, text="Window size (bp)", bg="#454545", width=24, height=1, font=police, bd=5, fg="white").grid(row=12,column=1, columnspan=2,sticky=W+E)
    window_size = Scale(OptionsWindow, orient='horizontal', from_=2000, to=50000,resolution=10, tickinterval=2, length=340)
    window_size.set(fen_g)
    window_size.grid(row=13,column=1, columnspan=2,sticky=W+E)

    texte6 = Label(OptionsWindow, text="Arrow width", bg="#454545", width=24, height=1, font=police, bd=5, fg="white").grid(row=14,column=1, columnspan=2,sticky=W+E)
    arrow_size = Scale(OptionsWindow, orient='horizontal', from_=500, to=1500,resolution=10, tickinterval=2, length=340)
    arrow_size.set(Size_arrow)
    arrow_size.grid(row=15,column=1, columnspan=2,sticky=W+E)

    texte7 = Label(OptionsWindow, text="Scale", bg="#454545", width=24, height=1, font=police, bd=5, fg="white").grid(row=16,column=1, columnspan=2,sticky=W+E)
    expan = Scale(OptionsWindow, orient='horizontal', from_=0.5, to=3,resolution=0.1, length=340)
    expan.set(expansion_g)
    expan.grid(row=17,column=1, columnspan=2,sticky=W+E)

    v5 = IntVar()
    texte5=Label(OptionsWindow, text="Coloration mode", bg="#454545", width=24, height=1, font=police, bd=5, fg="white").grid(row=18,column=1, columnspan=2,sticky=W+E)
    con1 = Radiobutton(OptionsWindow, text="all", variable=v5, value=1, bg="#b2b2b2", width=18, height=1)
    con1.grid(row=19,column=1,sticky=W+E)
    con2 = Radiobutton(OptionsWindow, text="monochrome (<A>#..):", variable=v5,command= lambda : v.set(2), value=2, bg="#b2b2b2", width=18, height=1)
    con2.grid(row=20,column=1,sticky=W+E)
    con3 = Radiobutton(OptionsWindow, text="from annotation file...", variable=v5,command= lambda : ChooseColorAnnotFile(v,OptionsWindow), value=3, bg="#b2b2b2", width=18, height=1)
    con3.grid(row=21,column=1,sticky=W+E)
    con4 = Radiobutton(OptionsWindow, text="from identifiers file...", variable=v5,command= lambda : ChooseColorWPFile(v,OptionsWindow), value=4, bg="#b2b2b2", width=18, height=1)
    con4.grid(row=22,column=1,sticky=W+E)
    text_coloration = Text(OptionsWindow, width=18, height=1,bg="#b2b2b2",bd=3)
    text_coloration.grid(row=20,column=2,sticky=W+E)


    if col_g == "sen":
        v.set(1)
    else:
        v.set(2)
    if sort_g == "fasta":
        v2.set(1)
    else:
        v2.set(2)
    if WP_appear is True:
        v3.set(1)
    else:
        v3.set(2)
    if CONTIG_appear is True:
        v4.set(1)
    else:
        v4.set(2)
    if LOCTAG_appear is True:
        v7.set(1)
    else:
        v7.set(2)
    if global_coloration == "normal":
        v5.set(1)
    elif global_coloration == "file_annot":
        v5.set(3)
        v.set(2)
    elif global_coloration == "file_wp":
        v5.set(4)
        v.set(2)
    else:
        v5.set(2)
        v.set(2)
    if NAME_appear is True:
        v6.set(1)
    else:
        v6.set(2)
    texte4 = Label(OptionsWindow, bg="#454545", width=24, height=1, font=police, bd=5, fg="white").grid(row=23,column=1, columnspan=2,sticky=W+E)
    run = Button (OptionsWindow, text = "OK", command = lambda : RefreshOptions(v.get(),v2.get(),window_size.get(),root_x,filename,v3.get(),v4.get(),arrow_size.get(),v5.get(),text_coloration.get("1.0",END),v6.get(),expan.get(),OptionsWindow,v7.get()), font=police, bg="#b2b2b2").grid(row=24,column=1, columnspan=2,sticky=E+W)
    texte4 = Label(OptionsWindow, bg="#454545", width=24, height=1, font=police, bd=5, fg="white").grid(row=25,column=1, columnspan=2,sticky=W+E)
    OptionsWindow.columnconfigure(1, weight=1)
    OptionsWindow.columnconfigure(2, weight=1)
    for n in range(25):
        OptionsWindow.rowconfigure(n, weight=1)
################################################################################

def ChooseColorAnnotFile(v,OptionsWindow):
    """open an annotation coloration file"""
    global dico_color_file
    global global_coloration
    global dico_name_file
    global col_g
    global file_color_g
    col_g = "eq"
    v.set(2)
    try:
        file_color = askopenfilename(filetypes = [("txt files","*.txt")], title="Color file").encode("cp1252")
    except:
        OptionsWindow.lift()
        return ""
    if file_color == "None":
        global_coloration = "normal"
    elif file_color == "" or file_color == "()":
        global_coloration = "normal"
    else:
        file_color = file_color.replace("/","\\")
        file_color_g = file_color[:]
        global_coloration = "file_annot"
        dico_color_file = {}
        dico_name_file = {}
        file_color_read = readfile(file_color)
        color = ""
        name = ""
        for i in file_color_read:
            if i.find(">")!=-1:
                tab = i.rstrip().replace(">","").split("\t")
                color = tab[0]
                try:
                    name = tab[1]
                except:
                    name = "NA"
            else:
                dico_color_file[i.rstrip().lower()] = color
                dico_name_file[i.rstrip().lower()] = name
    OptionsWindow.lift()
def ChooseColorWPFile(v,OptionsWindow):
    """open an ids coloration file"""
    global dico_color_file
    global global_coloration
    global dico_name_file
    global col_g
    global file_color_g
    col_g = "eq"
    v.set(2)
    try:
        file_color = askopenfilename(filetypes = [("txt files","*.txt")], title="Color file").encode("cp1252")
    except:
        OptionsWindow.lift()
        return ""
    if file_color == "None":
        global_coloration = "normal"
    elif file_color == "" or file_color == "()":
        global_coloration = "normal"
    else:
        file_color = file_color.replace("/","\\")
        file_color_g = file_color[:]
        global_coloration = "file_wp"
        dico_color_file = {}
        dico_name_file = {}
        file_color_read = readfile(file_color)
        color = ""
        name = ""
        for i in file_color_read:
            if i.find(">")!=-1:
                tab = i.rstrip().replace(">","").split("\t")
                color = tab[0]
                try:
                    name = tab[1]
                except:
                    name = "NA"
            else:
                try:
                    dico_color_file[i.split("\t")[1].rstrip()] = color
                    dico_name_file[i.split("\t")[1].rstrip()] = name
                except:
                    continue
    OptionsWindow.lift()

def RefreshOptions(col,sort,w_s,root_x,filename,wp,contig,arrows,global_coloration_x,annot_x,name,exp,Wind,loc):
    """set options"""
    global col_g
    global sort_g
    global fen_g
    global WP_appear
    global CONTIG_appear
    global Size_arrow
    global global_coloration
    global NAME_appear
    global expansion_g
    global LOCTAG_appear
    if col == 1:
        col_g = "sen"
    else:
        col_g = "eq"
    if sort == 1:
        sort_g = "fasta"
    else:
        sort_g = "alpha"
    if wp == 1:
        WP_appear = True
    else:
        WP_appear = False
    if contig == 1:
        CONTIG_appear = True
    else:
        CONTIG_appear = False
    if name == 1:
        NAME_appear = True
    else:
        NAME_appear = False
    if loc == 1:
        LOCTAG_appear = True
    else:
        LOCTAG_appear = False
    Size_arrow = int(arrows)
    fen_g = int(w_s)
    expansion_g = float(exp)
    if fen_g*expansion_g > 65000:
        expansion_g = 1
    if global_coloration_x == 1:
        global_coloration = "normal"
    if global_coloration_x == 2:
        col_g = "eq"
        global_coloration = annot_x.rstrip()
    Wind.destroy()

######################################################################################################################
def SelectionLaunch(filename,root_x):
    """launch data from selection"""
    global data_set_g
    global T
    global path_infile_g
    # if str(T.get("1.0",END)).find("\t")!=-1:
    data_set_g = "sele"
    path_infile_g = str(T.get("1.0",END))
    Context_Launcher(path_infile_g,root_x,"","multi")

######################################################################################################################
def SelectionClear():
    """clear selection"""
    global T
    global data_set_g
    T.delete("1.0",END)

######################################################################################################################
def FormatageMenu(root_x):
    """open window of formatage"""
    FMWindow= Toplevel()
    FMWindow.wm_title("Format a database")
    # FMWindow.attributes("-topmost", True)

    FMWindow.configure(background="#454545")
    colonne0 =Label(FMWindow, bg="#454545").grid(row=0,column=0, rowspan=13)
    colonne1 =Label(FMWindow, bg="#454545").grid(row=0,column=3, rowspan=13)

    v = StringVar()
    lab = Label(FMWindow,text="Source of GFF", bg="#454545", width=55, height=1, font=police, bd=5, fg="white").grid(row=0,column=0, columnspan=4,sticky=W+E)
    sen1  = Radiobutton(FMWindow, text="NCBI", variable=v, value="ncbi", bg="#b2b2b2", width=18, height=1)
    sen1.grid(row=1,column=1,sticky=W+E)
    sen2 = Radiobutton(FMWindow, text="Other", variable=v, value="other", bg="#b2b2b2", width=18, height=1)
    sen2.grid(row=1,column=2,sticky=W+E)

    v1 = StringVar()
    lab = Label(FMWindow,text="NCBI: Assembly reports in same folder as GFF files?", bg="#454545", width=48, height=1, font=police, bd=5, fg="white").grid(row=3,column=0, columnspan=4,sticky=W+E)
    sen1  = Radiobutton(FMWindow, text="yes", variable=v1, value="yes", bg="#b2b2b2", width=18, height=1)
    sen1.grid(row=4,column=1,sticky=W+E)
    sen2 = Radiobutton(FMWindow, text="no", variable=v1, value="no", bg="#b2b2b2", width=18, height=1)
    sen2.grid(row=4,column=2,sticky=W+E)

    v1_2 = StringVar()
    lab = Label(FMWindow,text="NCBI: Original names of GFF files?", bg="#454545", width=48, height=1, font=police, bd=5, fg="white").grid(row=5,column=0, columnspan=4,sticky=W+E)
    sen1  = Radiobutton(FMWindow, text="yes", variable=v1_2, value="yes", bg="#b2b2b2", width=18, height=1)
    sen1.grid(row=6,column=1,sticky=W+E)
    sen2 = Radiobutton(FMWindow, text="no", variable=v1_2, value="no", bg="#b2b2b2", width=18, height=1)
    sen2.grid(row=6,column=2,sticky=W+E)

    v2 = StringVar()
    lab2 = Label(FMWindow, text="Choose a folder with GFF (and assembly report)", bg="#454545", width=24, height=1, font=police, bd=5, fg="white").grid(row=7,column=0, columnspan=4,sticky=W+E)
    con3 = Button(FMWindow, text="Select folder...",command= lambda : Choosefolder(v2,FMWindow,lab3), bg="#b2b2b2", width=18, height=1)
    con3.grid(row=8,column=1, columnspan=2 ,sticky=W+E)
    lab3 = Label(FMWindow, bg="#b2b2b2", width=24, height=1,bd=5)
    lab3.grid(row=9,column=1, columnspan=2,sticky=W+E)

    v3 = StringVar()
    lab4 = Label(FMWindow, text="Choose a destination folder", bg="#454545", width=24, height=1, font=police, bd=5, fg="white").grid(row=10,column=0, columnspan=4,sticky=W+E)
    con4 = Button(FMWindow, text="Select folder...",command= lambda : Choosefolder(v3,FMWindow,lab5), bg="#b2b2b2", width=18, height=1)
    con4.grid(row=11,column=1, columnspan=2,sticky=W+E)
    lab5 = Label(FMWindow, bg="#b2b2b2", width=24, height=1,bd=5)
    lab5.grid(row=12,column=1, columnspan=2,sticky=W+E)

    lab4 = Label(FMWindow, text="Format", bg="#454545", width=24, height=1, font=police, bd=5, fg="white").grid(row=13,column=0, columnspan=4,sticky=W+E)
    run = Button (FMWindow, text = "Go!", command = lambda : FormatageLaunch(v.get(),v1.get(),v1_2.get(),v2.get(),v3.get(),FMWindow), font=police, bg="#b2b2b2").grid(row=14,column=1, columnspan=2,sticky=E+W)
    lab = Label(FMWindow, bg="#454545", width=24, height=1, font=police, bd=5, fg="white").grid(row=15,column=0, columnspan=5,sticky=W+E)
    FMWindow.columnconfigure(1, weight=1)
    FMWindow.columnconfigure(2, weight=1)
    for n in range(15):
        FMWindow.rowconfigure(n, weight=1)

    v.set("ncbi")
    v1.set("yes")
    v1_2.set("yes")
    v2.set("")
    v3.set("")

######################################################################################################################
def ListPathChoose():
    """selection of list path"""
    global path_path
    global PATH
    global WARNING_g
    global WARNING_tot
    global T2
    try:
        new_path = askopenfilename(filetypes = [("txt files","*.txt")], title="List of strains", initialdir=PATH[1]).encode("cp1252")
    except:
        return ""
    if new_path != "None":
        if new_path != "" and new_path != "()":
            new_path = new_path.replace("/","\\")
            new_content = ""
            old_content = readfile(path_path)
            compteur_l = 0
            for l in old_content:
                lf = l[:]
                if l.find("#")==-1:
                    compteur_l += 1
                    if compteur_l == 1:
                        lf = "List_path\t"+new_path+"\n"
                new_content += lf
            out = open(path_path, "w")
            out.write(new_content)
            out.close()
            pathr_x = open(path_path)
            PATH = []
            patht_x = pathr_x.readlines()
            pathr_x.close()
            for l in patht_x:
                if l.find("#")==-1:
                    PATH.append(l.split("\t")[1].rstrip())
            if new_path != "":
                T2.insert(END,"INFO: New selected GFM database : "+new_path+"\n")
                T2.tag_add('infolisc', str(WARNING_tot)+'.0', str(WARNING_tot+1)+'.0')
                T2.tag_config('infolisc', foreground='black')
                T2.see(END)
                WARNING_tot += 1
            actualize_ng()

######################################################################################################################
def DBPathChoose():
    """selection of gfm folder"""
    global path_path
    global PATH
    global WARNING_g
    global WARNING_tot
    global T2
    try:
        new_path = askdirectory(title="Database folder",initialdir=PATH[1]).encode("cp1252")
    except:
        return ""
    if new_path != "None":
        if str(new_path) != "" and  str(new_path) !="()":
            new_path = new_path.replace("/","\\")
            new_path += "\\"
            new_content = ""
            old_content = readfile(path_path)
            compteur_l = 0
            for l in old_content:
                lf = l[:]
                if l.find("#")==-1:
                    compteur_l += 1
                    if compteur_l == 2:
                        lf = "DB_path\t"+new_path+"\n"
                new_content += lf
            out = open(path_path, "w")
            out.write(new_content)
            out.close()
            pathr_x = open(path_path)
            PATH = []
            patht_x = pathr_x.readlines()
            pathr_x.close()
            for l in patht_x:
                if l.find("#")==-1:
                    PATH.append(l.split("\t")[1].rstrip())
            if new_path != "":
                T2.insert(END,"INFO: New gfm database in "+new_path+"\n")
                T2.tag_add('infodbc', str(WARNING_tot)+'.0', str(WARNING_tot+1)+'.0')
                T2.tag_config('infodbc', foreground='black')
                T2.see(END)
                WARNING_tot += 1
            actualize_ng()

######################################################################################################################
def FormatageLaunch(source,reports,change,direct,direct2,window):
    """launch formatage"""
    global WARNING_g
    global WARNING_tot
    global T2
    global root
    if "" in [source,change,direct,direct2]:
        window.lift()
        return 0
    else:
        window.destroy()
        formatage = 2
        if source == "ncbi":
            if change == "no" or reports=="no":
                formatage = 1
        else:
            formatage = 0
        root.config(cursor="watch")
        root.update()
        ProgressW= Toplevel() ##
        ProgressW.wm_title("Formatting progress...") ##
        file_t = StringVar() ##
        progress=ttk.Progressbar(ProgressW,orient=HORIZONTAL,length=100,mode='determinate') ##
        progress.config(maximum=100)
        progress.grid(row=0,column=0,sticky=N+E+W+S) ##
        pol = tkFont.Font(family='Courrier', size=8, weight=tkFont.BOLD)
        FileTreated = Label(ProgressW,textvariable=file_t, bg="#b2b2b2", width=70, height=5,font=pol, bd=5 ).grid(row=1,column=0,sticky=N+E+W+S) ##
        archive_folder =  glob.glob(direct+"*.gff.gz")
        for i in archive_folder:
            file_t.set("Uncompressing "+i)
            zip = gzip.open(i)
            contzip = zip.read()
            zip.close()
            out = open(i.replace(".gz",""), "w")
            [out.write(x) for x in contzip]
            out.close()
            os.system("DEL "+i)
        folder = glob.glob(direct+"*.gff")
        compteur_local = 0
        for n,i in enumerate(folder):
            file_t.set(i) ##
            ProgressW.update_idletasks() ##
            compteur_local += 1
            out = i[:]
            path_gff = out.split("\\")
            gff_file1 = path_gff.pop()
            if formatage == 2:
                try:
                    gff_file2 = gff_file1.split("_")[0]+"_"+gff_file1.split("_")[1]+".gfm"
                    out = direct2+gff_file2
                except:
                    T2.insert(END,"ERROR: GFF file name has been changed: "+i+". Please inform GeneSpy that you changed names compared to NCBI.\n")
                    T2.tag_add('errdb', str(WARNING_tot)+'.0', str(WARNING_tot+1)+'.0')
                    T2.tag_config('errdb', foreground='red')
                    T2.see(END)
                    WARNING_tot += 1
                    ProgressW.destroy() ##
                    root.config(cursor="")
                    root.update()
                    return 0
            if formatage == 1 or formatage == 0:###MODIFIED
                try:
                    gff_file2 = gff_file1.split("_")[0]+"_"+gff_file1.split("_")[1]+".gfm"
                    out = direct2+gff_file2
                    if os.path.isfile(out) is False:
                        out = re.sub(r"\.gff", ".gfm", direct2+gff_file1)
                except:
                    out = re.sub(r"\.gff", ".gfm",direct2+gff_file1)
            if os.path.isfile(out) is False:
                cont = readfile(i)
                outw = open(out, "w")
                loctag = "NA"
                current_contig = ""
                compteur_genes = 0###MODIFIED
                for l in cont:
                    l = l.rstrip()
                    if l.find("##FASTA")!=-1:
                        break
                    if re.match(r"^#", l) is None:
                        if re.match(r"$\n", l) is not None:
                            continue
                        if formatage == 0:
                            tab= l.split("\t")
                            if len(tab) > 1:
                                if current_contig != tab[0]:
                                    outw.write("#"+tab[0]+" ()\n")
                                    current_contig = tab[0]
                        else:
                            if l.find("\tregion\t")!=-1 and l.find("taxon")!=-1:
                                tab= l.split("\t")
                                tab2 = l.split("genome=")
                                try:
                                    genome = re.sub(r";.+","",tab2[1]).rstrip()
                                except:
                                    tab3 = l.split("type=")
                                    try:
                                        genome = re.sub(r";.+","",tab3[1]).rstrip()
                                    except:
                                        print "No type detected"
                                outw.write("#"+tab[0]+" ("+genome+")\n")
                        if l.find("\tgene\t")!=-1:
                            tab= l.split("\t")
                            tab2 = tab.pop().split(";")
                            for j in tab2:
                                if j.find("locus_tag=")!=-1:
                                    loctag = j.split("=")[1].rstrip()
                                    break
                        if l.find("\tCDS\t")!=-1:
                            compteur_genes += 1###MODIFIED
                            tab = l.split("\t")
                            tab2 = tab.pop().split(";")
                            inf = tab[3]
                            sup = tab[4]
                            sens = tab[6]
                            wp = ""
                            prod = ""
                            gene = ""
                            if formatage == 0:
                                name = ""
                                for j in tab2:
                                    if j.find("ID=")!=-1:###MODIFIED
                                        wp = j.split("=")[1]
                                    if j.find("pseudo=true")!=-1:
                                        wp = "pseudogene"
                                    if j.find("Name=")!=-1:
                                        name = j.split("=")[1]
                                    if j.find("gene=")!=-1:
                                        gene = j.split("=")[1]
                                    if j.find("locus_tag=")!=-1:###MODIFIED
                                        loctag = j.split("=")[1].rstrip()###MODIFIED
                                    if j.find("product=")!=-1:
                                        prod = j.split("=")[1]
                                if prod == "":
                                    if name != "":
                                        prod = name[:]
                                    else:
                                        prod = "undefined"
                                if wp == "":
                                    wp = str(compteur_genes).zfill(8)+".1"

                            else:
                                for j in tab2:
                                    if j.find("product=")!=-1:
                                        prod = j.split("=")[1]
                                    if j.find("Name=")!=-1:
                                        wp = j.split("=")[1]
                                    if j.find("pseudo=true")!=-1:
                                        wp = "pseudogene"
                                    if j.find("gene=")!=-1:
                                        gene = j.split("=")[1]
                                    if j.find("locus_tag=")!=-1:###MODIFIED
                                        loctag = j.split("=")[1].rstrip()###MODIFIED
                                if loctag == "NA" and gene != "":
                                    loctag = gene
                                    gene = ""
                            outw.write(inf+"\t"+sup+"\t"+sens+"\t"+wp+"\t"+loctag+"\t"+prod+"\t"+gene+"\n")
                            loctag = "NA"
                        if l.find("\ttRNA\t")!=-1:
                            tab= l.split("\t")
                            tab2 = tab.pop().split(";")
                            inf = tab[3]
                            sup = tab[4]
                            sens = tab[6]
                            prod = ""
                            for j in tab2:
                                if j.find("product=")!=-1:
                                    prod = j.split("=")[1]
                            outw.write(inf+"\t"+sup+"\t"+sens+"\tNA\t"+loctag+"\t"+prod+"\ttRNA\n")
                            loctag = "NA"
                        if l.find("\trRNA\t")!=-1:
                            tab= l.split("\t")
                            tab2 = tab.pop().split(";")
                            inf = tab[3]
                            sup = tab[4]
                            sens = tab[6]
                            prod = ""
                            for j in tab2:
                                if j.find("product=")!=-1:
                                    prod = j.split("=")[1]
                            outw.write(inf+"\t"+sup+"\t"+sens+"\tNA\t"+loctag+"\t"+prod+"\trRNA\n")
                            loctag = "NA"
                outw.close()
                if compteur_genes == 0:
                    T2.insert(END,"WARNING: A problem occurred in format of  "+i+" : file empty.\n")
                    T2.tag_add('warndb', str(WARNING_tot)+'.0', str(WARNING_tot+1)+'.0')
                    T2.tag_config('warndb', foreground='darkorange2')
                    T2.see(END)
                    WARNING_tot += 1
            progress['value']=int((n+1)/float(len(folder)+1)*100) ##
            progress.update() ##
        T2.insert(END,"INFO: DB formatted in "+direct+": GFM files: "+str(compteur_local)+"/"+str(len(folder))+"\n")
        T2.tag_add('infofor', str(WARNING_tot)+'.0', str(WARNING_tot+1)+'.0')
        T2.tag_config('infofor', foreground='black')
        T2.see(END)
        file_t.set("Creating SQL Database ...") ##
        progress.update() ##
        folder_gfm = glob.glob(direct2+"*.gfm")
        if os.path.isfile(direct2+'sql.db') is True:
            os.system("del "+direct2+"sql.db")
        try:
            conn = sqlite3.connect(direct2+'sql.db')
            c = conn.cursor()
            c.execute('''CREATE TABLE IDS (assembly, accession)''')

            for i in folder_gfm:
                content_gfm = readfile(i)
                for j in content_gfm:
                    if re.match(r"^#",j) is None:
                        if j.split("\t")[3] != "pseudogene" and j.split("\t")[3] != "NA":
                            gca = i.split("\\").pop().replace(".gfm","")
                            wp = re.sub(r"\..", "", j.split("\t")[3])
                            c.execute('''INSERT INTO IDS VALUES''' +str((gca,wp)))
        except:
            T2.insert(END,"ERROR: Impossible to create SQL database in "+direct2+". Special character in database path can lead to errors\n")
            T2.tag_add('errdb', str(WARNING_tot)+'.0', str(WARNING_tot+1)+'.0')
            T2.tag_config('errdb', foreground='red')
            T2.see(END)
            WARNING_tot += 1
            progress['value']=100 ##
            ProgressW.update() ##
            conn.commit()
            conn.close()
            ProgressW.destroy() ##
            root.config(cursor="")
            root.update()
            return 0
        T2.insert(END,"INFO: SQL file created in "+direct2+" : "+str(len(folder_gfm))+" GFM connected\n")
        T2.tag_add('infofor', str(WARNING_tot)+'.0', str(WARNING_tot+1)+'.0')
        T2.tag_config('infofor', foreground='black')
        T2.see(END)

        WARNING_tot += 1
        progress['value']=100 ##
        progress.update() ##
        conn.commit()
        conn.close()
        ProgressW.destroy() ##
        root.config(cursor="")
        root.update()
        return 1

######################################################################################################################
def ListMenu(root_x):
    """Create a list of strains"""
    LSWindow= Toplevel()
    LSWindow.wm_title("Create a list of strains")
    # LSWindow.attributes("-topmost", True)

    LSWindow.configure(background="#454545")
    colonne0 =Label(LSWindow, bg="#454545").grid(row=0,column=0, rowspan=13)
    colonne1 =Label(LSWindow, bg="#454545").grid(row=0,column=3, rowspan=13)

    v = StringVar()
    lab = Label(LSWindow,text="Source of GFF", bg="#454545", width=55, height=1, font=police, bd=5, fg="white").grid(row=0,column=0, columnspan=4,sticky=W+E)
    sen1  = Radiobutton(LSWindow, text="NCBI", variable=v, value="ncbi", bg="#b2b2b2", width=18, height=1)
    sen1.grid(row=1,column=1,sticky=W+E)
    sen2 = Radiobutton(LSWindow, text="Other", variable=v, value="other", bg="#b2b2b2", width=18, height=1)
    sen2.grid(row=1,column=2,sticky=W+E)

    v1 = StringVar()
    lab = Label(LSWindow,text="NCBI: Assembly reports in same folder as GFF files?", bg="#454545", width=48, height=1, font=police, bd=5, fg="white").grid(row=3,column=0, columnspan=4,sticky=W+E)
    sen1  = Radiobutton(LSWindow, text="yes", variable=v1, value="yes", bg="#b2b2b2", width=18, height=1)
    sen1.grid(row=4,column=1,sticky=W+E)
    sen2 = Radiobutton(LSWindow, text="no", variable=v1, value="no", bg="#b2b2b2", width=18, height=1)
    sen2.grid(row=4,column=2,sticky=W+E)

    v1_2 = StringVar()
    lab = Label(LSWindow,text="NCBI: Original names of GFF files?", bg="#454545", width=48, height=1, font=police, bd=5, fg="white").grid(row=5,column=0, columnspan=4,sticky=W+E)
    sen1  = Radiobutton(LSWindow, text="yes", variable=v1_2, value="yes", bg="#b2b2b2", width=18, height=1)
    sen1.grid(row=6,column=1,sticky=W+E)
    sen2 = Radiobutton(LSWindow, text="no", variable=v1_2, value="no", bg="#b2b2b2", width=18, height=1)
    sen2.grid(row=6,column=2,sticky=W+E)

    v2 = StringVar()
    lab2 = Label(LSWindow, text="Choose a folder with GFF (and assembly report)", bg="#454545", width=24, height=1, font=police, bd=5, fg="white").grid(row=7,column=0, columnspan=4,sticky=W+E)
    con3 = Button(LSWindow, text="Select folder...",command= lambda : Choosefolder(v2,LSWindow,lab3), bg="#b2b2b2", width=18, height=1)
    con3.grid(row=8,column=1, columnspan=2 ,sticky=W+E)
    lab3 = Label(LSWindow, bg="#b2b2b2", width=24, height=1,bd=5)
    lab3.grid(row=9,column=1, columnspan=2,sticky=W+E)

    v3 = StringVar()
    lab4 = Label(LSWindow, text="Choose a destination folder", bg="#454545", width=24, height=1, font=police, bd=5, fg="white").grid(row=10,column=0, columnspan=4,sticky=W+E)
    con4 = Button(LSWindow, text="Select folder...",command= lambda : Choosefolder(v3,LSWindow,lab5), bg="#b2b2b2", width=18, height=1)
    con4.grid(row=11,column=1, columnspan=2,sticky=W+E)
    lab5 = Label(LSWindow, bg="#b2b2b2", width=24, height=1,bd=5)
    lab5.grid(row=12,column=1, columnspan=2,sticky=W+E)

    lab4 = Label(LSWindow, text="Create list of strains", bg="#454545", width=24, height=1, font=police, bd=5, fg="white").grid(row=13,column=0, columnspan=4,sticky=W+E)
    run = Button (LSWindow, text = "Go!", command = lambda : ListeSpecBuilder(v.get(),v1.get(),v1_2.get(),v2.get(),v3.get(),LSWindow), font=police, bg="#b2b2b2").grid(row=14,column=1, columnspan=2,sticky=E+W)
    lab = Label(LSWindow, bg="#454545", width=24, height=1, font=police, bd=5, fg="white").grid(row=15,column=0, columnspan=5,sticky=W+E)
    LSWindow.columnconfigure(1, weight=1)
    LSWindow.columnconfigure(2, weight=1)
    for n in range(15):
        LSWindow.rowconfigure(n, weight=1)

    v.set("ncbi")
    v1.set("yes")
    v1_2.set("yes")
    v2.set("")
    v3.set("")

def ListeSpecBuilder(source,reports,change,direct,direct2,window):
    """creates a list of strains from ncbi"""
    global WARNING_g
    global WARNING_tot
    global T2
    global root
    if "" in [source,change,direct,direct2]:
        window.lift()
        return 0
    else:
        window.destroy()
        formatage = 2
        if source == "ncbi":
            if change == "no" or reports=="no":
                formatage = 1
        else:
            formatage = 0
        if formatage == 2:
            root.config(cursor="watch")
            root.update()
            archive_folder =  glob.glob(direct+"*.gff.gz")
            for i in archive_folder:
                zip = gzip.open(i)
                contzip = zip.read()
                zip.close()
                out = open(i.replace(".gz",""), "w")
                [out.write(x) for x in contzip]
                out.close()
                os.system("DEL "+i)
            folder = glob.glob(direct+"*.gff")
            folder_rep = glob.glob(direct+"*_assembly_*.txt")
            if len(folder) != len(folder_rep):
                listmissing = tkMessageBox.askyesno("report files missing", "Some assembly report files are missing, name of strains will be not found. Do you want to continue anyway?")
                if listmissing is False:
                    T2.insert(END,"ERROR: Assembly report files missing! Check connexion and use download module to retrieve them\n")
                    T2.tag_add('errlis', str(WARNING_tot)+'.0', str(WARNING_tot+1)+'.0')
                    T2.tag_config('errlis', foreground='red')
                    T2.see(END)
                    WARNING_tot += 1
                    root.config(cursor="")
                    root.update()
                    return 0

            #listew = open(direct+"list_strains.txt", "w")
            compteur_local = 0
            ProgressW= Toplevel() ##
            ProgressW.wm_title("Progress of list construction...") ##
            file_t = StringVar() ##
            progress=ttk.Progressbar(ProgressW,orient=HORIZONTAL,length=100,mode='determinate') ##
            progress.config(maximum=100)
            progress.grid(row=0,column=0,sticky=N+E+W+S) ##
            pol = tkFont.Font(family='Courrier', size=8, weight=tkFont.BOLD)
            FileTreated = Label(ProgressW,textvariable=file_t, bg="#b2b2b2", width=70, height=5,font=pol, bd=5 ).grid(row=1,column=0,sticky=N+E+W+S) ##
            list_genomes = []
            for n,i in enumerate(folder):
                gca = ""
                spec_name = ""
                f_spec_name = ""
                cont = readfile(i)
                file_t.set(i) ##
                ProgressW.update_idletasks() ##
                for l in cont:
                    compteur_ok = 0
                    if l.find("#!genome-build-accession NCBI_Assembly")!=-1:
                        gca = l.split(":")[1].rstrip()#.replace("GCA_","")
                        gca_origin = gca[:]
                        for rep in folder_rep:
                            if rep.find(gca)!=-1:
                                rep_cont = readfile(rep)
                                for l2 in rep_cont:
                                    if l2.find("Organism name:")!=-1:
                                        tab_ligne = l2.split()
                                        tab_ligne.pop(0)
                                        tab_ligne.pop(0)
                                        tab_ligne.pop(0)
                                        # regex = re.compile(r"Organism name\:\s+")
                                        spec_name = " ".join(tab_ligne)
                                        spec_name = re.sub(r"\(.+", "", spec_name)
                                        if spec_name[-1] == " ":
                                            spec_name = spec_name[:-1]
                                        compteur_local += 1
                                        compteur_ok = 1
                                    if len(spec_name.split(" ")) <= 2:
                                        if l2.find("strain=")!=-1:
                                            spec_name += " "+l2.split("strain=")[1].rstrip()
                                            break
                                break
                        f_spec_name = spec_name[:]
                        f_spec_name = f_spec_name.replace(".", "_")
                        f_spec_name = f_spec_name.replace(" ", "_")
                        f_spec_name = f_spec_name.replace("\'", "_")
                        f_spec_name = f_spec_name.replace("-", "_")
                        f_spec_name = f_spec_name.replace("[", "_")
                        f_spec_name = f_spec_name.replace("]", "_")
                        f_spec_name = f_spec_name.replace(")", "_")
                        f_spec_name = f_spec_name.replace("(", "_")
                        f_spec_name = f_spec_name.replace("/", "_")
                        f_spec_name = f_spec_name.replace("=", "_")
                        f_spec_name = f_spec_name.replace("@", "_")
                        f_spec_name = f_spec_name.replace("~", "_")
                        f_spec_name = f_spec_name.replace("|", "_")
                        f_spec_name = f_spec_name.replace("{", "_")
                        f_spec_name = f_spec_name.replace("}", "_")
                        f_spec_name = f_spec_name.replace("+", "_")
                        f_spec_name = f_spec_name.replace("%", "_")
                        f_spec_name = f_spec_name.replace("\"", "_")
                        if compteur_ok ==0:
                            T2.insert(END,"WARNING: Problem in list : "+gca_origin+" name not found\n")
                            T2.tag_add('pblis', str(WARNING_tot)+'.0', str(WARNING_tot+1)+'.0')
                            T2.tag_config('pblis', foreground='darkorange2')
                            T2.see(END)
                            WARNING_tot += 1
                        break
                if gca == "":
                    T2.insert(END,"WARNING: A problem occurred in list creation for "+i+"\n")
                    T2.tag_add('warnlis', str(WARNING_tot)+'.0', str(WARNING_tot+1)+'.0')
                    T2.tag_config('warnlis', foreground='darkorange2')
                    T2.see(END)
                    WARNING_tot += 1
                list_genomes.append(gca+"\t"+spec_name+"\t"+f_spec_name+"\n")
                progress['value']=int((n+1)/float(len(folder))*100) ##
                ProgressW.update() ##
            listew = open(direct2+"list_strains.txt", "w")
            for gnome in sorted(list_genomes, key=lambda t:t.split("\t")[1]):
                listew.write(gnome)
            listew.close()
            ProgressW.destroy() ##
            T2.insert(END,"INFO: Strains list has been created in "+direct2+" : Found strains: "+str(compteur_local)+"/"+str(len(folder))+"\n")
            T2.tag_add('infolis', str(WARNING_tot)+'.0', str(WARNING_tot+1)+'.0')
            T2.tag_config('infolis', foreground='black')
            T2.see(END)
            WARNING_tot += 1
            root.config(cursor="")
            root.update()
            return compteur_local
        else:
            folder = glob.glob(direct+"*.gff")
            listew = open(direct2+"list_strains.txt", "w")
            compteur_local = 0
            for i in sorted(folder):
                compteur_local += 1
                name_genome = i.split("\\").pop().replace(".gff","")
                listew.write(name_genome+"\t"+name_genome.replace("_", " ")+"\t"+name_genome+"\n")
            listew.close()
            T2.insert(END,"INFO: Strains list has been created in "+direct2+" : Found strains: "+str(compteur_local)+"/"+str(len(folder))+"\n")
            T2.tag_add('infolis', str(WARNING_tot)+'.0', str(WARNING_tot+1)+'.0')
            T2.tag_config('infolis', foreground='black')
            T2.see(END)
            WARNING_tot += 1
            root.config(cursor="")
            root.update()
            return compteur_local



def DataChange(col_n,name_x,ann_x,col_a,text_out,path_anfile):
    """edit color of genes"""
    col_n = str(col_n.rstrip())
    name_x = str(name_x.rstrip())
    ann_x = str(ann_x.rstrip())
    col_a = str(col_a.rstrip())
    # color_authorized = ['blue', 'orange', 'green', 'red', 'purple', 'brown', 'pink', 'gray', 'olive', 'cyan']
    OK = True
    if col_n != "":
        if col_n.find("#")!=-1 and len(col_n) != 7:
            OK = False
            text_out.insert(END,"Color[1] has to be in format : #XXXXXX (hexadecimal) or a color name\n")
        # if col_n.find("#")==-1:
        #     control_color = 0
        #     for colora in color_authorized:
        #         if col_n == colora:
        #             control_color += 1
        #             break
        #     if control_color == 0:
        #         OK = False
        #         text_out.insert(END,"Color[1] has to be in format : #XXXXXX (hexadecimal) or a color name\n")
    if name_x != "":
        if len(name_x) > 6:
            OK = False
            text_out.insert(END,"Name has to be composed of 6 characters maximum\n")
    if col_a != "":
        if col_a.find("#")!=-1 and len(col_a) != 7:
            OK = False
            text_out.insert(END,"Color[2] has to be in format : #XXXXXX (hexadecimal) or a color name\n")
        # if col_a.find("#")==-1:
        #     control_color = 0
        #     for colora in color_authorized:
        #         if col_a == colora:
        #             control_color += 1
        #             break
        #     if control_color == 0:
        #         OK = False
        #         text_out.insert(END,"Color[2] has to be in format : #XXXXXX (hexadecimal) or a color name\n")

    if OK is True:
        if col_n != "" and name_x != "":
            namer = readfile(path_anfile+"NameCol.txt")
            existant = 0
            namer_new = []
            for l in namer:
                if l.split("\t")[0] == name_x.lower():
                    namer_new.append(name_x.lower()+"\t"+col_n+"\n")
                    existant += 1
                else:
                    namer_new.append(l)
            if existant == 0:
                namer_new.append(name_x.lower()+"\t"+col_n+"\n")
            namew = open(path_anfile+"NameCol.txt", "w")
            [namew.write(i) for i in namer_new]
            namew.close()
            text_out.insert(END,"New link added : "+col_n+" "+name_x+"\n")
        if ann_x != "" and name_x != "":
            corrr = readfile(path_anfile+"AnnotName.txt")
            existant = 0
            # print corrr
            corrr_new = []
            for l in corrr:
                if l.split("\t")[0] == ann_x.lower():
                    corrr_new.append(ann_x.lower()+"\t"+name_x.lower()+"\n")
                    existant += 1
                else:
                    corrr_new.append(l)
            # print existant
            if existant == 0:
                corrr_new.append(ann_x.lower()+"\t"+name_x.lower()+"\n")
                annotr = readfile(path_anfile+"AnnotCol.txt")
                existant = 0
                annotr_new = []
                for k,l in enumerate(annotr):
                    if l.split("\t")[0] == ann_x.lower():
                        # annotr_new.append(ann_x.lower()+"\t"+col_a+"\n")
                        existant += 1
                if existant == 0:
                    text_out.insert(END,"Annotation not found!\n")
                    return ""

            if col_n == "":
                namer = readfile(path_anfile+"NameCol.txt")
                existant = 0
                namer_new = []
                for k,l in enumerate(namer):
                    if l.split("\t")[0] == name_x.lower():
                        # namer_new.append(name_x.lower()+"\t"+col_n+"\n")
                        existant += 1
                    else:
                        namer_new.append(l)
                if existant == 0:
                    namer_new.append(name_x.lower()+"\tred\n")
                    namew = open(path_anfile+"NameCol.txt", "w")
                    [namew.write(i) for i in namer_new]
                    namew.close()
            corrw = open(path_anfile+"AnnotName.txt", "w")
            [corrw.write(i) for i in corrr_new]
            corrw.close()
            text_out.insert(END,"New link added : "+name_x+" "+ann_x+"\n")
        if ann_x != "" and col_a != "":
            annotr = readfile(path_anfile+"AnnotCol.txt")
            existant = 0
            annotr_new = []
            for k,l in enumerate(annotr):
                if l.split("\t")[0] == ann_x.lower():
                    annotr_new.append(ann_x.lower()+"\t"+col_a+"\n")
                    existant += 1
                else:
                    annotr_new.append(l)
            if existant == 0:
                text_out.insert(END,"Annotation not found!\n")
                return ""
            annotw = open(path_anfile+"AnnotCol.txt", "w")
            [annotw.write(i) for i in annotr_new]
            annotw.close()
            text_out.insert(END,"New link added : "+ann_x+" "+col_a+"\n")
        if name_x != "":
            corr2r = readfile(path_anfile+"NameName.txt")
            existant = 0
            corr2r_new = []
            for k,l in enumerate(corr2r):
                if l.split("\t")[0] == name_x.lower():
                    corr2r_new.append(name_x.lower()+"\t"+name_x+"\n")
                    existant += 1
                else:
                    corr2r_new.append(l)
            if existant == 0:
                corr2r_new.append(name_x.lower()+"\t"+name_x+"\n")
            corr2w = open(path_anfile+"NameName.txt", "w")
            [corr2w.write(i) for i in corr2r_new]
            corr2w.close()
        # text_out.insert(END,"New link added : "+col_n+" "+name_x+" "+ann_x+" "+col_a+"\n")
    text_out.see(END)

def Palette(event,txt_wid,DataWindow):
    color = askcolor()
    try:
        txt_wid.delete(0,END)
        txt_wid.insert(END,color[1])
    except:
        return ""
def DataMenu(path_anfile):
    """menu of edition of color of genes"""
    global root
    DataWindow= Toplevel(bg="#454545")
    DataWindow.wm_title("Edit data")
    # DataWindow.attributes("-topmost", True)
    enteted = Label(DataWindow, text="Edit data binding", bg="#454545", width=45, height=1, font=police, bd=5, fg="white").grid(row=0,column=0, columnspan=9,sticky=E+W+N+S)
    lab0 = Label(DataWindow, bg="#454545", width=2, height=1, bd=5).grid(row=1,column=0,rowspan=4)
    lab1 = Label(DataWindow, text="Color", bg="#454545", width=8, height=1, bd=5, fg="white").grid(row=1,column=1)
    lab0 = Label(DataWindow, bg="#454545", width=2, height=1, bd=5).grid(row=1,column=2)
    lab1 = Label(DataWindow, text="Name", bg="#454545", width=8, height=1, bd=5, fg="white").grid(row=1,column=3)
    lab0 = Label(DataWindow, bg="#454545", width=2, height=1,  bd=5).grid(row=1,column=4)
    lab1 = Label(DataWindow, text="Function", bg="#454545", width=8, height=1, bd=5, fg="white").grid(row=1,column=5)
    lab0 = Label(DataWindow, bg="#454545", width=2, height=1,  bd=5).grid(row=1,column=6)
    lab1 = Label(DataWindow, text="Color", bg="#454545", width=8, height=1, bd=5, fg="white").grid(row=1,column=7)
    lab0 = Label(DataWindow, bg="#454545", width=2, height=1,  bd=5).grid(row=1,column=8,rowspan=4)
    labi = Label(DataWindow, text="<->", bg="#454545", width=4, height=1,font=police, bd=5, fg="white").grid(row=2,column=2)
    labi = Label(DataWindow, text="<->", bg="#454545", width=4, height=1,font=police, bd=5, fg="white").grid(row=2,column=4)
    labi = Label(DataWindow, text="<->", bg="#454545", width=4, height=1,font=police, bd=5, fg="white").grid(row=2,column=6)
    text_col1 = Entry(DataWindow, width=8, bg="#b2b2b2",bd=3)
    text_col1.grid(row=2,column=1,sticky=E+W)
    data={"one": 1, "two": 2}
    text_col1.bind('<Double-Button-1>', lambda event, arg=data: Palette(event, text_col1,DataWindow))
    text_name = Entry(DataWindow, width=8,bg="#b2b2b2",bd=3)
    text_name.grid(row=2,column=3,sticky=E+W)
    text_annot = Entry(DataWindow, width=8, bg="#b2b2b2",bd=3)
    text_annot.grid(row=2,column=5,sticky=E+W)
    text_col2 = Entry(DataWindow, width=8,bg="#b2b2b2",bd=3)
    text_col2.grid(row=2,column=7,sticky=E+W)
    text_col2.bind('<Double-Button-1>', lambda event, arg=data: Palette(event, text_col2,DataWindow))
    change_b = Button (DataWindow, text = "Change data binding", command = lambda : DataChange(text_col1.get(),text_name.get(),text_annot.get(),text_col2.get(),text_out,path_anfile), font=police)
    change_b.grid(row=3,column=1, columnspan=7,sticky=E+W)
    text_out = Text(DataWindow, bg="#b2b2b2",bd=3, height=4)
    text_out.grid(row=4,column=1, columnspan=7,sticky=E+W+S+N)
    enteted = Label(DataWindow, text="Search a color", bg="#454545", width=45, height=1, font=police, bd=5, fg="white").grid(row=5,column=0, columnspan=9,sticky=E+W+N+S)
    lab1 = Label(DataWindow, text="Name", bg="#454545", width=8, height=1, bd=5, fg="white").grid(row=6,column=3)
    lab1 = Label(DataWindow, text="Function", bg="#454545", width=8, height=1, bd=5, fg="white").grid(row=6,column=5)
    text_name_get = Entry(DataWindow, width=8,bg="#b2b2b2",bd=3)
    text_name_get.grid(row=7,column=3,sticky=E+W)
    text_annot_get = Entry(DataWindow, width=8, bg="#b2b2b2",bd=3)
    text_annot_get.grid(row=7,column=5,sticky=E+W)
    get_b = Button (DataWindow, text = "Search associated color", command = lambda : DataSearch(text_name_get.get(),text_annot_get.get(),text_out_get,path_anfile), font=police)
    get_b.grid(row=8,column=1, columnspan=7,sticky=E+W)
    text_out_get = Text(DataWindow, bg="#b2b2b2",bd=3, height=4)
    text_out_get.grid(row=9,column=1, columnspan=7,sticky=E+W+N+S)
    lab0 = Label(DataWindow, bg="#454545", width=2, height=1,  bd=5, fg="white").grid(row=11,column=0,columnspan=9,sticky=E+W)
    get_b = Button (DataWindow, text = "Convert as annotation color file", command = lambda : ConvertColorFile(text_out_get.get("1.0",END),DataWindow), font=police)
    get_b.grid(row=10,column=1, columnspan=7,sticky=E+W)
    enteted = Label(DataWindow, text="Create an identifers color file", bg="#454545", width=45, height=1, font=police, bd=5, fg="white").grid(row=11,column=0, columnspan=9,sticky=E+W+N+S)
    lab0 = Label(DataWindow, bg="#454545", width=2, height=1,  bd=5, fg="white").grid(row=12,column=0,columnspan=9,sticky=E+W)
    get_b = Button (DataWindow, text = "Select a folder containing tabular files", command = lambda : CreateIDcolorfile(DataWindow), font=police)
    get_b.grid(row=13,column=1, columnspan=7,sticky=E+W)
    lab0 = Label(DataWindow, bg="#454545", width=2, height=1,  bd=5, fg="white").grid(row=14,column=0,columnspan=9,sticky=E+W)
    DataWindow.columnconfigure(1, weight=5)
    DataWindow.columnconfigure(3, weight=5)
    DataWindow.columnconfigure(5, weight=5)
    DataWindow.columnconfigure(7, weight=5)
    DataWindow.rowconfigure(4, weight=5)
    DataWindow.rowconfigure(9, weight=5)
def CreateIDcolorfile(Window):
    global path_infile_g
    global ColMan
    elements  = path_infile_g.split("/")
    filex = elements.pop()
    folder = "/".join(elements)
    # try:
    direct = str(askdirectory(title="Folder containing identifier files").encode("utf-8"))
    # except:
    # Window.lift()
    # print "miaou"
    # return ""
    if direct != "None":
        if str(direct) != "()" and str(direct) != "":
            content = glob.glob(direct+"/*.txt")
            if len(content) != 0:
                try:
                    name_file = asksaveasfilename(initialdir=folder,filetypes = [("Text file","*.txt")],title="Export color file").encode("utf-8")
                except:
                    Window.lift()
                    return ""
                if name_file != "None":
                    if name_file != "" and name_file != "()":
                        out = open(name_file,"w")
                        for i in content:
                            color_random = ColMan.htmlcolor(random.randint(0,255),random.randint(0,255),random.randint(0,255))
                            out.write(">"+color_random+"\n")
                            for l in readfile(i):
                                if l.find("\t")!=-1:
                                    out.write(l.rstrip()+"\n")
                        out.close()
            else:
                info = tkMessageBox.showinfo("Folder empty", "No txt file found")
                Window.lift()
                return ""
    Window.lift()
def ConvertColorFile(input_colors,DataWindow):
    global path_infile_g
    elements  = path_infile_g.split("\\")
    filex = elements.pop()
    folder = "\\".join(elements)
    tab_col = input_colors.split("\n")
    tab_final = []
    for i in tab_col:
        try:
            info = i.rstrip().split("\t")
            tab_final.append(">"+info[1])
            tab_final.append(info[0])
        except:
            continue
    name_out_file = asksaveasfilename(initialdir=folder,filetypes = [("Text file","*.txt")],title="Export color file")
    try:
        name_file = name_out_file.encode("cp1252")
    except:
        DataWindow.lift()
        return ""
    if name_file != "None":
        if name_file != "" and name_file != "()":
            name_out_file = name_out_file.replace("/","\\").replace(".txt","")+"txt"
            out_col_file = open(name_file,"w")
            [out_col_file.write(i+"\n") for i in tab_final]
            out_col_file.close()
    DataWindow.lift()

def DataSearch(name_x,ann_x,text_out_get,path_anfile):
    """search coloration of gene"""
    name_x = name_x.rstrip()
    ann_x = ann_x.rstrip()
    field = ""
    if name_x != "":
        namer = readfile(path_anfile+"NameCol.txt")
        for l in namer:
            if l.lower().find(name_x.lower())!=-1:
                field += l
    if ann_x != "":
        annotr = readfile(path_anfile+"AnnotCol.txt")
        for l in annotr:
            if l.lower().find(ann_x.lower())!=-1:
                field += l
    text_out_get.insert(END,field)
    text_out_get.see(END)

def SearchAdd(text_out):
    """transfers data from search window to root"""
    global data_set_g
    global T
    data_set_g = "sele"
    content_box = text_out.get("1.0",END)
    tab_content_box = content_box.split("\n")
    for i in tab_content_box:
        if i !="":
            try:
                T.insert(END,i.split("\t")[0]+"\t"+i.split("\t")[4]+"\t# "+i.split("\t")[6]+"\n")
                T.see(END)
            except:
                continue

def SearchGene(event,genome_x,gene_x,text_out,type_info,c):
    """search a gene in database"""
    global PATH
    global root
    global T2
    global WARNING_tot
    if type(gene_x) is not str:
        gene_x = gene_x.get()
        genome_x = genome_x.get()
    try:
        lister = readfile(PATH[0])
    except:
        T2.insert(END,"ERROR: Strains list "+PATH[0]+" not found, please inform GeneSpy the path of Stains list.\n")
        T2.tag_add('errses',  str(WARNING_tot)+'.0', str(WARNING_tot+1)+'.0')
        T2.tag_config('errses', foreground='red')
        T2.see(END)
        WARNING_tot += 1
        return "ERROR"
    genome_x = genome_x.rstrip()
    gene_x = gene_x.rstrip()
    gca_liste = []
    liste_genes_found = []
    # print "imia"
    if gene_x != "":
        if genome_x == "":
            for l in lister:
                gca_liste.append(l.split("\t")[0])
        else:
            for l in lister:
                if l.lower().find(genome_x.lower())!=-1:
                    gca_liste.append(l.split("\t")[0])
        gca_liste_present = []
        # print
        if type_info == "wp":
            try:  ################################################
                c.execute("""SELECT DISTINCT assembly FROM IDS WHERE accession=?""", (gene_x,))
                response = c.fetchall()
            except:
                T2.insert(END,"ERROR: SQL database misformated, please check if format has been properly performed\n")
                T2.tag_add('errsq',  str(WARNING_tot)+'.0', str(WARNING_tot+1)+'.0')
                T2.tag_config('errsq', foreground='red')
                T2.see(END)
                WARNING_tot += 1
                return "ERROR"


            # print response
            for gca in gca_liste:
                for gca2 in response:
                    if gca == str(gca2[0]):
                        gca_liste_present.append(gca)
        else:
            gca_liste_present = gca_liste
        # print gca_liste_present
        if type_info == "wp":
            for gca in gca_liste_present:
                try:
                    content_genome = readfile(PATH[1]+gca+".gfm")
                    for l in content_genome:
                        if l.lower().find(gene_x.lower())!=-1:
                            liste_genes_found.append(gca+"\t"+l)
                except:
                    continue
        else:
            root.config(cursor="watch")
            root.update()
            ProgressW= Toplevel() ##
            ProgressW.wm_title("Searching IDs from Keywords research ...") ##
            gca_t = StringVar() ##
            progress=ttk.Progressbar(ProgressW,orient=HORIZONTAL,length=100,mode='determinate') ##
            progress.config(maximum=100)
            progress.grid(row=0,column=0,sticky=N+E+W+S) ##
            pol = tkFont.Font(family='Courrier', size=8, weight=tkFont.BOLD)
            FileTreated = Label(ProgressW,textvariable=gca_t, bg="#b2b2b2", width=70, height=5,font=pol, bd=5 ).grid(row=1,column=0,sticky=N+E+W+S) ##
            for n,gca in enumerate(gca_liste_present):
                gca_t.set(gca) ##
                ProgressW.update_idletasks() ##
                progress['value']=int((n+1)/float(len(gca_liste_present))*100) ##
                ProgressW.update() ##
                try:
                    content_genome = readfile(PATH[1]+gca+".gfm")
                    for l in content_genome:
                        if l.lower().find(gene_x.lower())!=-1:
                            liste_genes_found.append(gca+"\t"+l)
                except:
                    continue

            ProgressW.destroy() ##
            root.config(cursor="")
            root.update()
            text_out.insert(END,"#### Keyword : "+gene_x+" ####\n")
            if len(liste_genes_found) == 0:
                text_out.insert(END,"Nothing found!\n")
                text_out.see(END)
                return 0
        for i in liste_genes_found:
            text_out.insert(END,i)
            text_out.see(END)
        if type_info != "wp":
            text_out.insert(END,"####  Matching hits: "+str(len(liste_genes_found))+" genes/"+str(len(gca_liste))+" strains ####\n")
            text_out.see(END)
    if len(liste_genes_found) == 0:
        return 0
    else:
        return len(liste_genes_found)


def SearchMenu():
    """menu of search"""
    SearchWindow= Toplevel(bg="#454545")
    SearchWindow.wm_title("Search")
    # SearchWindow.attributes("-topmost", True)
    enteted = Label(SearchWindow, text="Keywords research", bg="#454545", width=20, height=1, font=police, bd=5, fg="white").grid(row=0,column=1, columnspan=1,sticky=E+W+N+S)
    enteted = Label(SearchWindow, text="Research from files", bg="#454545", width=20, height=1, font=police, bd=5, fg="white").grid(row=0,column=3, columnspan=1,sticky=E+W+N+S)
    lab0 = Label(SearchWindow, bg="#454545", width=2, height=1, bd=5).grid(row=1,column=0,rowspan=4,sticky=E+W)
    lab1 = Label(SearchWindow, text="Species/part of strains", bg="#454545", width=30, height=1, bd=5, fg="white").grid(row=1,column=1,sticky=E+W)
    lab0 = Label(SearchWindow, bg="#454545", width=2, height=1, bd=5).grid(row=1,column=2)
    lab1 = Label(SearchWindow, text="Keyword (any annotation)", bg="#454545", width=30, height=1, bd=5, fg="white").grid(row=3,column=1,sticky=E+W)
    lab0 = Label(SearchWindow, bg="#454545", width=2, height=1,  bd=5).grid(row=1,column=8,rowspan=4,sticky=E+W)
    text_out = Text(SearchWindow, bg="#b2b2b2",bd=3)
    text_out.grid(row=10,column=1, columnspan=3,sticky=E+W+N+S)
    Scr_out = Scrollbar(SearchWindow, orient=VERTICAL,bg="#454545")
    Scr_out.grid(row=10,column=4,sticky=N+S)
    Scr_out.config(command=text_out.yview)
    text_out.config(yscrollcommand=Scr_out.set)
    text_spec = Entry(SearchWindow, width=30, bg="#b2b2b2",bd=3)
    text_spec.grid(row=2,column=1,sticky=E+W)
    text_gene = Entry(SearchWindow, width=30, bg="#b2b2b2",bd=3)
    text_gene.grid(row=4,column=1,sticky=E+W)
    lab0 = Label(SearchWindow, bg="#454545", width=2, height=1,  bd=5).grid(row=3,column=0,sticky=E+W)
    search_b = Button (SearchWindow, text = "Search", command = lambda : SearchGene(None,text_spec,text_gene,text_out,"other",""), font=police)
    search_b.grid(row=6,column=1,columnspan=1,sticky=E+W)
    text_gene.bind("<Return>", lambda event, a=text_spec,b=text_gene, c=text_out, d="other",e="" : SearchGene(event,a,b,c,d,e))
    text_spec.bind("<Return>", lambda event, a=text_spec,b=text_gene, c=text_out, d="other",e="" : SearchGene(event,a,b,c,d,e))
    lab0 = Label(SearchWindow, fg="white", bg="#454545", width=2, height=1,  bd=5).grid(row=5,column=2,sticky=E+W)
    blast_b = Button (SearchWindow, text = "from NCBI BLASTP output", command = lambda : MenuBlastNcbi(text_out,SearchWindow), font=police)
    blast_b.grid(row=2,column=3,sticky=E+W)
    blast_b = Button (SearchWindow, text = "from local BLASTP output", command = lambda : LocalBlastPanel(text_out,SearchWindow), font=police)
    blast_b.grid(row=4,column=3,sticky=E+W)
    lab0 = Label(SearchWindow, bg="#454545", width=2, height=1,  bd=5).grid(row=7,column=0,sticky=E+W)
    blast_b = Button (SearchWindow, text = "from GenBank files", command = lambda : SearchGenBank(text_out,SearchWindow), font=police)
    blast_b.grid(row=6,column=3,sticky=E+W)
    lab0 = Label(SearchWindow, bg="#454545", width=2, height=1,  bd=5).grid(row=11,column=0,sticky=E+W)
    list_b = Button (SearchWindow, text = "from accession list file", command = lambda : SearchList(text_out,SearchWindow), font=police)
    list_b.grid(row=8,column=3,sticky=E+W)
    lab0 = Label(SearchWindow, bg="#454545", width=2, height=1,  bd=5).grid(row=9,column=0,sticky=E+W)
    clear_b = Button (SearchWindow, text = "Clear", command = lambda : text_out.delete("1.0",END), font=police)
    clear_b.grid(row=12,column=1,sticky=E+W)
    add_b = Button (SearchWindow, text = "Add to selection", command = lambda : SearchAdd(text_out), font=police)
    add_b.grid(row=12,column=3,sticky=E+W)
    lab0 = Label(SearchWindow, bg="#454545", width=2, height=1,  bd=5).grid(row=13,column=0,sticky=E+W)
    SearchWindow.columnconfigure(1, weight=1)
    SearchWindow.columnconfigure(3, weight=1)
    SearchWindow.rowconfigure(10, weight=1)


def SearchList(text_out_get,SearchWindow):
    global WARNING_tot
    global WARNING_g
    global PATH
    try:
        path_liste = askopenfilename(filetypes = [("text files","*.txt")], title="Accession list").encode("cp1252")
    except:
        Searchwindow.lift()
        return ""
    # print path_liste
    if path_liste != "None" and path_liste != "":
        if path_liste != "" and path_liste != "()":
            root.config(cursor="watch")
            root.update()
            ProgressW= Toplevel() ##
            ProgressW.wm_title("Searching IDs from accession list ...") ##
            file_t = StringVar() ##
            progress=ttk.Progressbar(ProgressW,orient=HORIZONTAL,length=100,mode='determinate') ##
            progress.config(maximum=100)
            progress.grid(row=0,column=0,sticky=N+E+W+S) ##
            pol = tkFont.Font(family='Courrier', size=8, weight=tkFont.BOLD)
            FileTreated = Label(ProgressW,textvariable=file_t, bg="#b2b2b2", width=70, height=5,font=pol, bd=5 ).grid(row=1,column=0,sticky=N+E+W+S) ##
            try:
                conn = sqlite3.connect(PATH[1]+'sql.db')
            except:
                ProgressW.destroy()
                T2.insert(END,"ERROR: No SQL database found\n")
                T2.tag_add('errbl', str(WARNING_tot)+'.0', str(WARNING_tot+1)+'.0')
                T2.tag_config('errbl', foreground='red')
                T2.see(END)
                WARNING_tot += 1
                root.config(cursor="")
                root.update()
                SearchWindow.lift()
                return ""
            c = conn.cursor()
            dico_wps = {}
            content = readfile(path_liste)
            for i in content:
                wp = re.sub(r"\..","", i.rstrip())
                dico_wps[wp] = ""
            compteur = 0
            positive = 0
            positive_unic = 0
            text_out_get.insert(END,"#### Accession list ####\n")
            for wp in dico_wps.keys():
                compteur += 1
                ####################################
                req = SearchGene(None,"",wp,text_out_get,"wp",c)
                if req == "ERROR":
                    break
                if req > 0:
                    positive +=req
                    positive_unic += 1
                ####################################
                file_t.set(wp) ##
                ProgressW.update_idletasks() ##
                progress['value']=int((compteur)/float(len(dico_wps))*100) ##
                ProgressW.update_idletasks() ##
            ProgressW.destroy() ##
            root.config(cursor="")
            root.update()
            conn.close()
            if positive == 0:
                text_out_get.insert(END,"Nothing found!\n")
                text_out_get.see(END)
            else:
                text_out_get.insert(END,"####  Matching hits: "+str(positive_unic)+" accessions/"+str(compteur)+" accessions ####\n")
                text_out_get.insert(END,"####  Matching hits: "+str(positive)+" genes/"+str(len(readfile(PATH[0])))+" strains ####\n")
                text_out_get.see(END)
    SearchWindow.lift()

def SearchGenBank(text_out_get,SearchWindow):
    global WARNING_tot
    global WARNING_g
    global PATH
    try:
        direct = str(askdirectory(title="Folder containing GenBank files").encode("cp1252"))
    except:
        SearchWindow.lift()
        return ""
    if direct != "None":
        if str(direct) != "()" and str(direct) != "":
            root.config(cursor="watch")
            root.update()
            ProgressW= Toplevel() ##
            ProgressW.wm_title("Searching IDs from GenBank files ...") ##
            file_t = StringVar() ##
            progress=ttk.Progressbar(ProgressW,orient=HORIZONTAL,length=100,mode='determinate') ##
            progress.config(maximum=100)
            progress.grid(row=0,column=0,sticky=N+E+W+S) ##
            pol = tkFont.Font(family='Courrier', size=8, weight=tkFont.BOLD)
            FileTreated = Label(ProgressW,textvariable=file_t, bg="#b2b2b2", width=70, height=5,font=pol, bd=5 ).grid(row=1,column=0,sticky=N+E+W+S) ##
            try:
                conn = sqlite3.connect(PATH[1]+'sql.db')
            except:
                ProgressW.destroy()
                T2.insert(END,"ERROR: No SQL database found\n")
                T2.tag_add('errbl', str(WARNING_tot)+'.0', str(WARNING_tot+1)+'.0')
                T2.tag_config('errbl', foreground='red')
                T2.see(END)
                WARNING_tot += 1
                root.config(cursor="")
                root.update()
                SearchWindow.lift()
                return ""
            c = conn.cursor()
            dico_wps = {}
            direct = direct.replace("/","\\")
            collection_gbk = glob.glob(direct+"\\*.gb")
            collection_gp = glob.glob(direct+"\\*.gp")
            for i in collection_gbk:
                content = readfile(i)
                for n,l in enumerate(content):
                    if n == 0 and l.find("LOCUS")==-1:
                        T2.insert(END,"WARNING: File "+i+" is not in GenBank format!\n")
                        T2.tag_add('warnbl', str(WARNING_tot)+'.0', str(WARNING_tot+1)+'.0')
                        T2.tag_config('warnbl', foreground='darkorange2')
                        T2.see(END)
                        WARNING_tot += 1
                        break
                    if l.find("/protein_id")!=-1:
                        wp = re.sub(r"\..","", l.split("=")[1].replace("\"","").rstrip())
                        dico_wps[wp] = ""
            for i in collection_gp:
                content = readfile(i)
                for n,l in enumerate(content):
                    if n == 0 and l.find("LOCUS")==-1:
                        T2.insert(END,"WARNING: File "+i+" is not in GenBank format!\n")
                        T2.tag_add('warnbl', str(WARNING_tot)+'.0', str(WARNING_tot+1)+'.0')
                        T2.tag_config('warnbl', foreground='darkorange2')
                        T2.see(END)
                        WARNING_tot += 1
                        break
                    if l.find("ACCESSION")!=-1:
                        wp = l.split()[1].rstrip()
                        dico_wps[wp] = ""
            compteur = 0
            positive = 0
            positive_unic = 0
            text_out_get.insert(END,"#### GenBank collection ####\n")
            for wp in dico_wps.keys():
                compteur += 1
                ####################################
                req = SearchGene(None,"",wp,text_out_get,"wp",c)
                if req == "ERROR":
                    break
                if req > 0:
                    positive +=req
                    positive_unic += 1
                ####################################
                file_t.set(wp) ##
                ProgressW.update_idletasks() ##
                progress['value']=int((compteur)/float(len(dico_wps))*100) ##
                ProgressW.update() ##
            ProgressW.destroy() ##
            root.config(cursor="")
            root.update()
            conn.close()
            if positive == 0:
                text_out_get.insert(END,"Nothing found!\n")
                text_out_get.see(END)
            else:
                text_out_get.insert(END,"####  Matching hits: "+str(positive_unic)+" accessions/"+str(compteur)+" accessions ####\n")
                text_out_get.insert(END,"####  Matching hits: "+str(positive)+" genes/"+str(len(readfile(PATH[0])))+" strains ####\n")
                text_out_get.see(END)
    SearchWindow.lift()

def LocalBlastPanel(text_out,SearchWindow):
    SearchLocalWindow= Toplevel(bg="#454545")
    SearchLocalWindow.wm_title("Search options")
    enteted = Label(SearchLocalWindow, text="Type regular expression, up/downstream of accession number", bg="#454545", width=55, height=1, font=police, bd=5, fg="white").grid(row=0,column=0, columnspan=5,sticky=E+W+N+S)
    lab0 = Label(SearchLocalWindow, bg="#454545", width=2, height=1, bd=5).grid(row=1,column=0,rowspan=4,sticky=E+W)
    lab1 = Label(SearchLocalWindow, text="Upstream regular expression", bg="#454545", width=30, height=1, bd=5, fg="white").grid(row=1,column=1,sticky=E+W)
    lab0 = Label(SearchLocalWindow, bg="#454545", text="<Accession number>", width=16, height=1, bd=5,fg="white").grid(row=2,column=2)
    lab1 = Label(SearchLocalWindow, text="Downstream regular expression", bg="#454545", width=30, height=1, bd=5, fg="white").grid(row=1,column=3,sticky=E+W)
    lab0 = Label(SearchLocalWindow, bg="#454545", width=2, height=1,  bd=5).grid(row=1,column=4,rowspan=4,sticky=E+W)
    lab0 = Label(SearchLocalWindow, bg="#454545", text="Use regular expressions to fit with your data (ex: .+@) and type an e-value threshold (ex: 1e-5)", width=80, height=3, bd=5, fg="white").grid(row=3,column=1,columnspan=3)
    lab1 = Label(SearchLocalWindow, text="E-value threshold", bg="#454545", width=30, height=1, bd=5, fg="white").grid(row=1,column=5,sticky=E+W)
    lab0 = Label(SearchLocalWindow, bg="#454545", width=2, height=1,  bd=5).grid(row=1,column=6,rowspan=4,sticky=E+W)
    text_up = Entry(SearchLocalWindow, width=30,bg="#b2b2b2",bd=3)
    text_up.grid(row=2,column=1,sticky=E+W)
    text_down = Entry(SearchLocalWindow, width=30,bg="#b2b2b2",bd=3)
    text_down.grid(row=2,column=3,sticky=E+W)
    text_ev = Entry(SearchLocalWindow, width=15,bg="#b2b2b2",bd=3)
    text_ev.grid(row=2,column=5)
    blast_b = Button (SearchLocalWindow, text = "Select a file", command = lambda : SearchBlastp(text_out,text_down.get(),text_up.get(),"local",SearchLocalWindow,text_ev.get(),SearchWindow,[]), font=police)
    blast_b.grid(row=4,column=1,columnspan=3,sticky=E+W)
    lab0 = Label(SearchLocalWindow, bg="#454545", width=2, height=1,  bd=5).grid(row=5,column=1,rowspan=4,sticky=E+W)
    SearchWindow.lift()

def Choosefile(field,window,label):
    try:
        path_liste = askopenfilename(filetypes = [("csv files","*.csv")], title="NCBI FTP links file").encode("cp1252")
    except:
        window.lift()
        return ""
    # print path_liste
    if path_liste != "None" and path_liste != "":
        if path_liste != "" and path_liste != "()":
            field.set(path_liste.replace("/","\\"))
            label.config(text=path_liste.replace("/","\\"))
    window.lift()


def Choosefolder(field,window,label):
    try:
        direct = str(askdirectory(title="Select a folder").encode("cp1252"))
    except:
        window.lift()
        return ""
    if direct != "None":
        if str(direct) != "()" and str(direct) != "":
            field.set(direct.replace("/","\\")+"\\")
            label.config(text=direct.replace("/","\\")+"\\")
    window.lift()




def MenuDownload():
    DLWindow= Toplevel()
    DLWindow.wm_title("Download GFF and assembly reports")
    # DLWindow.attributes("-topmost", True)

    DLWindow.configure(background="#454545")
    colonne0 =Label(DLWindow, bg="#454545").grid(row=0,column=0, rowspan=13)
    colonne1 =Label(DLWindow, bg="#454545").grid(row=0,column=3, rowspan=13)

    v = StringVar()
    lab = Label(DLWindow,text="Select database", bg="#454545", width=48, height=1, font=police, bd=5, fg="white").grid(row=0,column=0, columnspan=4,sticky=W+E)
    sen1  = Radiobutton(DLWindow, text="RefSeq", variable=v, value="GCF_", bg="#b2b2b2", width=18, height=1)
    sen1.grid(row=1,column=1,sticky=W+E)
    sen2 = Radiobutton(DLWindow, text="GenBank", variable=v, value="GCA_", bg="#b2b2b2", width=18, height=1)
    sen2.grid(row=1,column=2,sticky=W+E)

    v2 = StringVar()
    lab2 = Label(DLWindow, text="Choose a NCBI FTP links file", bg="#454545", width=24, height=1, font=police, bd=5, fg="white").grid(row=2,column=0, columnspan=4,sticky=W+E)
    con3 = Button(DLWindow, text="Select file...",command= lambda : Choosefile(v2,DLWindow,lab3), bg="#b2b2b2", width=18, height=1)
    con3.grid(row=3,column=1, columnspan=2 ,sticky=W+E)
    lab3 = Label(DLWindow, bg="#b2b2b2", width=24, height=1,bd=5)
    lab3.grid(row=4,column=1, columnspan=2,sticky=W+E)

    v3 = StringVar()
    lab4 = Label(DLWindow, text="Choose a destination folder", bg="#454545", width=24, height=1, font=police, bd=5, fg="white").grid(row=5,column=0, columnspan=4,sticky=W+E)
    con4 = Button(DLWindow, text="Select folder...",command= lambda : Choosefolder(v3,DLWindow,lab5), bg="#b2b2b2", width=18, height=1)
    con4.grid(row=6,column=1, columnspan=2,sticky=W+E)
    lab5 = Label(DLWindow, bg="#b2b2b2", width=24, height=1,bd=5)
    lab5.grid(row=7,column=1, columnspan=2,sticky=W+E)

    lab4 = Label(DLWindow, text="Dowload", bg="#454545", width=24, height=1, font=police, bd=5, fg="white").grid(row=8,column=0, columnspan=4,sticky=W+E)
    run = Button (DLWindow, text = "Go!", command = lambda : DownloadGenomes(v.get(),v2.get(),v3.get(),DLWindow), font=police, bg="#b2b2b2").grid(row=9,column=1, columnspan=2,sticky=E+W)
    lab = Label(DLWindow, bg="#454545", width=24, height=1, font=police, bd=5, fg="white").grid(row=10,column=0, columnspan=5,sticky=W+E)
    DLWindow.columnconfigure(1, weight=1)
    DLWindow.columnconfigure(2, weight=1)
    for n in range(7):
        DLWindow.rowconfigure(n, weight=1)

    v.set("GCF_")
    v2.set("")
    v3.set("")

def DownloadGenomes(refgen,path_liste,direct,window):
    """download gff files from ncbi"""
    global WARNING_tot
    global WARNING_g
    global root
    global police
    global T2
    if "" in [refgen,path_liste,direct]:
        window.lift()
        return 0
    else:
        window.destroy()
        listgenomer = readfile(path_liste)
        root.config(cursor="watch")
        root.update()
        compteur_local_gff = 0
        compteur_local_assembly = 0
        connection_error = 0
        compteur_general_genomes = 0
        dico_links = {}
        global_errors = 0
        Format_ok = False
        for n,l in enumerate(listgenomer):
            if l.find("#")==-1:
                if l.find(",")==-1:
                    T2.insert(END,"ERROR: Wrong format of NCBI FTP links file\n")
                    T2.tag_add('errlis', str(WARNING_tot)+'.0', str(WARNING_tot+1)+'.0')
                    T2.tag_config('errlis', foreground='red')
                    T2.see(END)
                    WARNING_tot += 1
                    root.config(cursor="")
                    root.update()
                    return 0
                if l.find("ftp://ftp.ncbi.nlm.nih.gov")!=-1:
                    Format_ok = True
                if Format_ok is False:
                    T2.insert(END,"ERROR: Wrong format of NCBI FTP links file\n")
                    T2.tag_add('errlis', str(WARNING_tot)+'.0', str(WARNING_tot+1)+'.0')
                    T2.tag_config('errlis', foreground='red')
                    T2.see(END)
                    WARNING_tot += 1
                    root.config(cursor="")
                    root.update()
                    return 0
                link = ""
                tab_l = []
                for f in sorted(l.split(","),reverse=True):
                    if f.find(refgen)!=-1:
                        compteur_general_genomes += 1
                        try:
                            link = f.rstrip().replace("\"","")
                            filex = link.split("/").pop().rstrip()+"_genomic.gff"
                            url = link+"/"+filex+".gz"
                            filez = direct+"\\"+filex
                            dico_links[url] = filez
                            ids = link.split("/").pop()
                            url = link+"/"+ids+"_assembly_report.txt"
                            filex = link.split("/").pop().rstrip()+"_assembly_report.txt"
                            filez = direct+"\\"+filex
                            dico_links[url] = filez
                        except:
                            T2.insert(END,"ERROR: Wrong format of NCBI FTP links file\n")
                            T2.tag_add('errlis', str(WARNING_tot)+'.0', str(WARNING_tot+1)+'.0')
                            T2.tag_config('errlis', foreground='red')
                            T2.see(END)
                            WARNING_tot += 1
                            root.config(cursor="")
                            root.update()
                            return 0
        while compteur_general_genomes*2 != compteur_local_gff+compteur_local_assembly:
            ProgressW= Toplevel() ##
            ProgressW.wm_title("Progress of download...") ##
            file_t = StringVar() ##
            progress=ttk.Progressbar(ProgressW,orient=HORIZONTAL,length=100,mode='determinate') ##
            progress.config(maximum=100)
            progress.grid(row=0,column=0,sticky=N+E+W+S) ##
            pol = tkFont.Font(family='Courrier', size=8, weight=tkFont.BOLD)
            FileTreated = Label(ProgressW,textvariable=file_t, bg="#b2b2b2", width=70, height=5,font=pol, bd=5 ).grid(row=1,column=0,sticky=N+E+W+S) ##
            compteur_progress = 0
            proxy = urllib2.ProxyHandler(proxies)
            opener = urllib2.build_opener(proxy)
            urllib2.install_opener(opener)
            for link in dico_links.keys():
                compteur_progress+=1
                if connection_error >= 3:
                    Confirmation2 = tkMessageBox.askyesno("Problem of connexion","Connexion problem detected. Do you want to continue downloading anyway?")
                    if Confirmation2 is True:
                        connection_error = 0
                    else:
                        T2.insert(END,"ERROR: Connexion to NCBI failed. It may be due to NCBI server problem but also to your connexion. Please check your connexion and your proxy setup\n")
                        T2.tag_add('errlis', str(WARNING_tot)+'.0', str(WARNING_tot+1)+'.0')
                        T2.tag_config('errlis', foreground='red')
                        T2.see(END)
                        WARNING_tot += 1
                        ProgressW.destroy()
                        root.config(cursor="")
                        root.update()
                        return 0
                file_t.set(dico_links[link])
                ProgressW.update_idletasks()
                if os.path.isfile(dico_links[link]) is False:
                    if link.find(".gff")!=-1:
                        try:
                            req = urllib2.Request(link)
                            req.add_header('Accept-encoding','gzip')
                            page = urllib2.urlopen(req)
                            buf = StringIO(page.read())
                            f = gzip.GzipFile(fileobj=buf)
                            data = f.read()
                            connection_error = 0
                            out = open(dico_links[link], "w")
                            [out.write(x) for x in data]
                            out.close()
                            compteur_local_gff += 1
                        except:
                            #################################
                            T2.insert(END,"WARNING: genome "+link+" not found.\n")
                            T2.tag_add('warnlis', str(WARNING_tot)+'.0', str(WARNING_tot+1)+'.0')
                            T2.tag_config('warnlis', foreground='darkorange2')
                            T2.see(END)
                            WARNING_tot += 1
                            connection_error += 1
                            global_errors+= 1
                    else:
                        try:
                            page = urllib2.urlopen(link)
                            f = open(dico_links[link], "w")
                            content = page.read()
                            f.write(content)
                            f.close()
                            connection_error = 0
                            compteur_local_assembly += 1
                        except:
                            #################################
                            T2.insert(END,"WARNING: report "+link+" not found\n")
                            T2.tag_add('warnlis', str(WARNING_tot)+'.0', str(WARNING_tot+1)+'.0')
                            T2.tag_config('warnlis', foreground='darkorange2')
                            T2.see(END)
                            WARNING_tot += 1
                            connection_error += 1
                            global_errors += 1
                else:
                    if link.find(".gff")!=-1:
                        compteur_local_gff += 1
                    else:
                        compteur_local_assembly += 1
                progress['value']=int((compteur_progress+1)/float(len(dico_links))*100) ##
                ProgressW.update() ##
            ProgressW.destroy() ##
            if global_errors != 0:
                Confirmation2 = tkMessageBox.askyesno("Error in download","Impossible to retrieve some files. Do you want to retry?")
                if Confirmation2 is True:
                    compteur_local_gff = 0
                    compteur_local_assembly = 0
                    connection_error = 0
                    global_errors = 0
                else:
                    T2.insert(END,"INFO: DB has been downloaded in "+direct+" : GFF files: "+str(compteur_local_gff)+"/"+str(compteur_general_genomes)+", assembly reports: "+str(compteur_local_assembly)+"/"+str(compteur_general_genomes)+"\n")
                    T2.tag_add('infolis', str(WARNING_tot)+'.0', str(WARNING_tot+1)+'.0')
                    T2.tag_config('infolis', foreground='black')
                    T2.see(END)
                    WARNING_tot += 1
                    root.config(cursor="")
                    root.update()
                    return 1
        T2.insert(END,"INFO: DB has been downloaded in "+direct+" : GFF files: "+str(compteur_local_gff)+"/"+str(compteur_general_genomes)+", assembly reports: "+str(compteur_local_assembly)+"/"+str(compteur_general_genomes)+"\n")
        T2.tag_add('infolis', str(WARNING_tot)+'.0', str(WARNING_tot+1)+'.0')
        T2.tag_config('infolis', foreground='black')
        T2.see(END)
        WARNING_tot += 1
        root.config(cursor="")
        root.update()
        return 1

def MenuBlastNcbi(text_out,SearchWindow):
    NBWindow= Toplevel()
    NBWindow.wm_title("Import NCBI BLASTP output")
    # NBWindow.attributes("-topmost", True)

    NBWindow.configure(background="#454545")
    colonne0 =Label(NBWindow, bg="#454545").grid(row=0,column=0, rowspan=4)
    colonne1 =Label(NBWindow, bg="#454545").grid(row=0,column=4, rowspan=4)

    ref = IntVar()
    gb = IntVar()
    lab = Label(NBWindow,text="GFM database", bg="#454545", width=55, height=1, font=police, bd=5, fg="white").grid(row=0,column=0, columnspan=4,sticky=W+E)
    sen1  = Checkbutton(NBWindow, text="RefSeq", variable=ref,bg="#b2b2b2", width=18, height=1)
    sen1.grid(row=1,column=1,sticky=W+E)
    sen2 = Checkbutton(NBWindow, text="GenBank", variable=gb, bg="#b2b2b2", width=18, height=1)
    sen2.grid(row=1,column=2,sticky=W+E)
    # lab4 = Label(NBWindow, text="Search from NCBI BLASTP output", bg="#454545", width=24, height=1, font=police, bd=5, fg="white").grid(row=3,column=0, columnspan=4,sticky=W+E)
    run = Button (NBWindow, text = "Select a file", command = lambda : SearchBlastp(text_out,"","","ncbi",NBWindow,0,SearchWindow,[ref.get(),gb.get()]), font=police, bg="#b2b2b2").grid(row=4,column=1, columnspan=2,sticky=E+W)
    lab = Label(NBWindow, bg="#454545", width=24, height=1, font=police, bd=5, fg="white").grid(row=5,column=0, columnspan=5,sticky=W+E)
    NBWindow.columnconfigure(1, weight=1)
    NBWindow.columnconfigure(2, weight=1)
    for n in range(5):
        NBWindow.rowconfigure(n, weight=1)

def SearchBlastp(text_out_get,down,up,type_blast,local_panel,ev,SearchWindow,source):
    """search from blastp file"""
    global WARNING_tot
    global WARNING_g
    global PATH
    source_type = []
    if type_blast == "ncbi":
        if source[0] == 0 and source[1] == 0:
            SearchWindow.lift()
            return ""
        else:
            if source[0] == 1:
                source_type.append("ref")
            if source[1] == 1:
                source_type.append("gb")
                source_type.append("dbj")
    if local_panel != "":
        local_panel.destroy()
    down = str(down).rstrip()
    up = str(up).rstrip()
    threshold = str(ev).rstrip()
    if type_blast == "local":
        if up == "" and down == "":
            info = tkMessageBox.showinfo("WARNING","No regular expression detected!")
            SearchWindow.lift()
            return ""
        if threshold == "":
            threshold = 0.0001
        else:
            threshold = float(threshold)
    blastwindow = askopenfilename(title="Select a BLASTP file")
    try:
        path_blast = blastwindow.encode("cp1252")
    except:
        SearchWindow.lift()
        return ""
    if path_blast != "None":
        if path_blast != "":
            root.config(cursor="watch")
            root.update()
            listblastr = readfile(path_blast)
            ProgressW= Toplevel() ##
            ProgressW.wm_title("Searching IDs from BLASTP output ...") ##
            file_t = StringVar() ##
            progress=ttk.Progressbar(ProgressW,orient=HORIZONTAL,length=100,mode='determinate') ##
            progress.config(maximum=100)
            progress.grid(row=0,column=0,sticky=N+E+W+S) ##
            pol = tkFont.Font(family='Courrier', size=8, weight=tkFont.BOLD)
            FileTreated = Label(ProgressW,textvariable=file_t, bg="#b2b2b2", width=70, height=5,font=pol, bd=5 ).grid(row=1,column=0,sticky=N+E+W+S) ##
            try:
                conn = sqlite3.connect(PATH[1]+'sql.db')
            except:
                ProgressW.destroy()
                T2.insert(END,"ERROR: No SQL database found\n")
                T2.tag_add('errbl', str(WARNING_tot)+'.0', str(WARNING_tot+1)+'.0')
                T2.tag_config('errbl', foreground='red')
                T2.see(END)
                WARNING_tot += 1
                root.config(cursor="")
                root.update()
                SearchWindow.lift()
                return ""
            c = conn.cursor()
            dico_wps = {}
            if type_blast == "local":
                regex = re.compile(r"%s(?P<Accession>.+?)%s" % (up,down))
                multi_space = re.compile(r"\s+")
                for n,i in enumerate(listblastr):
                    if n ==0 and i.find("BLASTP")==-1:
                        ProgressW.destroy()
                        T2.insert(END,"ERROR: This is not a local BLASTP output file!\n")
                        T2.tag_add('errbl', str(WARNING_tot)+'.0', str(WARNING_tot+1)+'.0')
                        T2.tag_config('errbl', foreground='red')
                        T2.see(END)
                        WARNING_tot += 1
                        root.config(cursor="")
                        root.update()
                        SearchWindow.lift()
                        return ""
                    table_blast = multi_space.split(i.rstrip())
                    if len(table_blast) >= 3:
                        try:
                            ev = float(re.sub(r"^e", "1e",table_blast.pop()))
                            score = table_blast.pop()
                            ligne_to_match = " ".join(table_blast)
                            m = regex.match(ligne_to_match)
                            if m is not None:
                                # print m.group('Accession')
                                if ev <= threshold:
                                    accession = m.group('Accession')
                                    accession = re.sub(r"\..", "",accession)
                                    dico_wps[accession] = ""
                        except:
                            continue
            else:
                for n,i in enumerate(listblastr):
                    if n ==0 and i.find("xml")==-1:
                        ProgressW.destroy()
                        T2.insert(END,"ERROR: This is not a XML NCBI BLASTP output file!\n")
                        T2.tag_add('errbl', str(WARNING_tot)+'.0', str(WARNING_tot+1)+'.0')
                        T2.tag_config('errbl', foreground='red')
                        T2.see(END)
                        WARNING_tot += 1
                        root.config(cursor="")
                        root.update()
                        SearchWindow.lift()
                        return ""
                    if n ==3 and i.find("blastp")==-1:
                        ProgressW.destroy()
                        T2.insert(END,"ERROR: This is not a XML NCBI BLASTP output file!\n")
                        T2.tag_add('errbl', str(WARNING_tot)+'.0', str(WARNING_tot+1)+'.0')
                        T2.tag_config('errbl', foreground='red')
                        T2.see(END)
                        WARNING_tot += 1
                        root.config(cursor="")
                        root.update()
                        SearchWindow.lift()
                        return ""
                    if i.find("<Hit_id>")!=-1 or i.find("<Hit_def>")!=-1:
                        tab = i.split("|")
                        for b,j in enumerate(tab):
                            if j in source_type:
                                dico_wps[re.sub(r"\..+","" ,tab[b+1])] = ""
            compteur = 0
            positive = 0
            positive_unic = 0
            text_out_get.insert(END,"#### BLASTP ####\n")
            for wp in dico_wps.keys():
                compteur += 1
                req = SearchGene(None,"",wp,text_out_get,"wp",c)
                if req == "ERROR":
                    break
                if req > 0:
                    positive +=req
                    positive_unic += 1
                file_t.set(wp) ##
                ProgressW.update_idletasks() ##
                progress['value']=int((compteur)/float(len(dico_wps))*100) ##
                ProgressW.update() ##
            ProgressW.destroy() ##
            root.config(cursor="")
            root.update()
            conn.close()
            if positive == 0:
                text_out_get.insert(END,"Nothing found!\n")
                text_out_get.see(END)
            else:
                text_out_get.insert(END,"####  Matching hits: "+str(positive_unic)+" accessions/"+str(compteur)+" accessions ####\n")
                text_out_get.insert(END,"####  Matching hits: "+str(positive)+" genes/"+str(len(readfile(PATH[0])))+" strains ####\n")
                text_out_get.see(END)
    text_out_get.see(END)
    SearchWindow.lift()
def GoTo(event):
    """search a gene in figure"""
    global fond
    global list_contexts_g
    global entry_search
    fond_x = fond
    list_contexts = list_contexts_g
    keyword = entry_search.get()
    index_frame = 0
    comp = 0
    keyword = keyword.rstrip()
    for i in list_contexts:
        if i.target_gca.lower().find(keyword.lower())!=-1:
            index_frame = i.target_index
            comp = 1
            break
        if i.target_wp.lower().find(keyword.lower())!=-1:
            index_frame = i.target_index
            comp = 1
            break
        if i.target_spec.lower().find(keyword.lower())!=-1:
            index_frame = i.target_index
            comp = 1
            break
    if comp ==1:
        ratio = (index_frame)/float(len(list_contexts))
        fond_x.yview_moveto(ratio)

def HyperLink(event):
    """open a link with default browser"""
    webbrowser.open(event.widget.cget("text"),new=2)

def OpenHelp():
    """open help section"""
    HelpWindow= Toplevel(bg="#454545")
    HelpWindow.wm_title("Help")
    pol = tkFont.Font(family='Courrier', size=9, weight=tkFont.BOLD)
    pol2 = tkFont.Font(family='Courrier', size=8, weight=tkFont.BOLD)
    pol2.configure(underline = True)
    enteted0 = Label(HelpWindow, text="For any information, please visit our site :", bg="#454545", width=55, height=1, font=pol, bd=5, fg="white")
    enteted0.grid(row=0,column=0,sticky=E+W+N+S)
    enteted = Label(HelpWindow, text="https://lbbe.univ-lyon1.fr/GeneSpy/", bg="#454545", width=55, height=1, font=pol2, bd=5, fg="white")
    enteted.grid(row=1,column=0,sticky=E+W+N+S)
    enteted2 = Label(HelpWindow, text="... or read the pdf joined to the package (Documentation.pdf)", bg="#454545", width=55, height=1, font=pol, bd=5, fg="white")
    enteted2.grid(row=2,column=0,sticky=E+W+N+S)
    enteted.bind("<Button-1>", HyperLink)
def OpenAbout():
    """open about section"""
    AboutWindow= Toplevel(bg="#454545")
    AboutWindow.wm_title("About ...")
    pol = tkFont.Font(family='Courrier', size=9, weight=tkFont.BOLD)
    pol2 = tkFont.Font(family='Courrier', size=8, weight=tkFont.BOLD)
    pol2.configure(underline = True)
    pol3 = tkFont.Font(family='Courrier', size=8, weight=tkFont.BOLD)
    enteted0 = Label(AboutWindow, text="To cite us :", bg="#454545", width=55, height=1, font=pol, bd=5, fg="white")
    enteted0.grid(row=0,column=0,sticky=E+W+N+S)
    enteted1 = Label(AboutWindow, text="PS Garcia, F Jauffrit, C Grangeasse, C Brochier-Armanet. GeneSpy, a simple tool to explore genomic context.", bg="#454545", width=100, height=1, font=pol3, bd=5, fg="white")
    enteted1.grid(row=1,column=0,sticky=E+W+N+S)
    enteted = Label(AboutWindow, text="https://lbbe.univ-lyon1.fr/GeneSpy/", bg="#454545", width=55, height=1, font=pol2, bd=5, fg="white")
    enteted.grid(row=2,column=0,sticky=E+W+N+S)
    enteted2 = Label(AboutWindow, text="Licence :", bg="#454545", width=55, height=1, font=pol, bd=5, fg="white")
    enteted2.grid(row=3,column=0,sticky=E+W+N+S)
    enteted3 = Label(AboutWindow, text="""Copyright or © or Copr.  Pierre Simon Garcia, Frédéric Jauffrit, Christophe Grangeasse,
    Céline Brochier-Armanet, CNRS, UCBL, (02/06/2017)

    pierre.garcia@etu.univ-lyon1.fr

    This software is a computer program whose purpose is to visualize genomic contexts.

    This software is governed by the CeCILL license under French law and
    abiding by the rules of distribution of free software.  You can  use,
    modify and/ or redistribute the software under the terms of the CeCILL
    license as circulated by CEA, CNRS and INRIA at the following URL
    "http://www.cecill.info".

    As a counterpart to the access to the source code and  rights to copy,
    modify and redistribute granted by the license, users are provided only
    with a limited warranty  and the software's author,  the holder of the
    economic rights,  and the successive licensors  have only  limited
    liability.

    In this respect, the user's attention is drawn to the risks associated
    with loading,  using,  modifying and/or developing or reproducing the
    software by the user in light of its specific status of free software,
    that may mean  that it is complicated to manipulate,  and  that  also
    therefore means  that it is reserved for developers  and  experienced
    professionals having in-depth computer knowledge. Users are therefore
    encouraged to load and test the software's suitability as regards their
    requirements in conditions enabling the security of their systems and/or
    data to be ensured and,  more generally, to use and operate it in the
    same conditions as regards security.

    The fact that you are presently reading this means that you have had
    knowledge of the CeCILL license and that you accept its terms.""", bg="#454545", width=55, height=33, font=pol, bd=5, fg="white")
    enteted3.grid(row=4,column=0,sticky=E+W+N+S)
    enteted.bind("<Button-1>", HyperLink)

def MenuBDB():
    BDBWindow= Toplevel()
    BDBWindow.wm_title("Build a local database")
    # BDBWindow.attributes("-topmost", True)

    BDBWindow.configure(background="#454545")
    colonne0 =Label(BDBWindow, bg="#454545").grid(row=0,column=0, rowspan=13)
    colonne1 =Label(BDBWindow, bg="#454545").grid(row=0,column=3, rowspan=13)

    v = StringVar()
    lab = Label(BDBWindow,text="Select database", bg="#454545", width=48, height=1, font=police, bd=5, fg="white").grid(row=0,column=0, columnspan=4,sticky=W+E)
    sen1  = Radiobutton(BDBWindow, text="RefSeq", variable=v, value="GCF_", bg="#b2b2b2", width=18, height=1)
    sen1.grid(row=1,column=1,sticky=W+E)
    sen2 = Radiobutton(BDBWindow, text="GenBank", variable=v, value="GCA_", bg="#b2b2b2", width=18, height=1)
    sen2.grid(row=1,column=2,sticky=W+E)

    v2 = StringVar()
    lab2 = Label(BDBWindow, text="Choose a NCBI FTP links file", bg="#454545", width=24, height=1, font=police, bd=5, fg="white").grid(row=2,column=0, columnspan=4,sticky=W+E)
    con3 = Button(BDBWindow, text="Select file...",command= lambda : Choosefile(v2,BDBWindow,lab3), bg="#b2b2b2", width=18, height=1)
    con3.grid(row=3,column=1, columnspan=2 ,sticky=W+E)
    lab3 = Label(BDBWindow, bg="#b2b2b2", width=24, height=1,bd=5)
    lab3.grid(row=4,column=1, columnspan=2,sticky=W+E)

    v3 = StringVar()
    lab4 = Label(BDBWindow, text="Choose a destination folder for database", bg="#454545", width=24, height=1, font=police, bd=5, fg="white").grid(row=5,column=0, columnspan=4,sticky=W+E)
    con4 = Button(BDBWindow, text="Select folder...",command= lambda : Choosefolder(v3,BDBWindow,lab5), bg="#b2b2b2", width=18, height=1)
    con4.grid(row=6,column=1, columnspan=2,sticky=W+E)
    lab5 = Label(BDBWindow, bg="#b2b2b2", width=24, height=1,bd=5)
    lab5.grid(row=7,column=1, columnspan=2,sticky=W+E)

    lab4 = Label(BDBWindow, text="Dowload", bg="#454545", width=24, height=1, font=police, bd=5, fg="white").grid(row=8,column=0, columnspan=4,sticky=W+E)
    run = Button (BDBWindow, text = "Go!", command = lambda : BasicDB(v.get(),v2.get(),v3.get(),BDBWindow), font=police, bg="#b2b2b2").grid(row=9,column=1, columnspan=2,sticky=E+W)
    lab = Label(BDBWindow, bg="#454545", width=24, height=1, font=police, bd=5, fg="white").grid(row=10,column=0, columnspan=5,sticky=W+E)
    BDBWindow.columnconfigure(1, weight=1)
    BDBWindow.columnconfigure(2, weight=1)
    for n in range(7):
        BDBWindow.rowconfigure(n, weight=1)

    v.set("GCF_")
    v2.set("")
    v3.set("")


def BasicDB(refgen,path_liste,direct,window):
    global WARNING_tot
    global WARNING_g
    global root
    global police
    global T2
    global path_path
    global PATH
    if "" in [refgen,path_liste,direct]:
        window.lift()
        return ""
    else:
        window.destroy()
        ret_ls = 0
        ret_dl = DownloadGenomes(refgen,path_liste,direct,window)
        if ret_dl == 1:
            ret_fm = FormatageLaunch("ncbi","yes","yes",direct,direct,window)
            if ret_fm == 1:
                ret_ls = ListeSpecBuilder("ncbi","yes","yes",direct,direct,window)
                if ret_ls == 0:
                    return ""
            else:
                return ""
        else:
            return ""
    try:
        os.system("mkdir "+direct+"gff_rep_collection\\")
        os.system("move "+direct+"*.gff "+direct+"gff_rep_collection\\")
        os.system("move "+direct+"*_assembly_*.txt "+direct+"gff_rep_collection\\")
    except:
        T2.insert(END,"WARNING: Compression of "+direct+"gff_rep_collection/ impossible\n")
        T2.tag_add('pblis', str(WARNING_tot)+'.0', str(WARNING_tot+1)+'.0')
        T2.tag_config('pblis', foreground='darkorange2')
        T2.see(END)
        WARNING_tot += 1
        root.config(cursor="")
        root.update()

    new_content = ""
    old_content = readfile(path_path)
    compteur_l = 0
    for l in old_content:
        lf = l[:]
        if l.find("#")==-1:
            compteur_l += 1
            if compteur_l == 1:
                lf = "List_path\t"+direct+"list_strains.txt\n"
            if compteur_l == 2:
                lf = "DB_path\t"+direct+"\n"
        new_content += lf
    out = open(path_path, "w")
    out.write(new_content)
    out.close()
    pathr_x = open(path_path)
    PATH = []
    patht_x = pathr_x.readlines()
    pathr_x.close()
    for l in patht_x:
        if l.find("#")==-1:
            PATH.append(l.split("\t")[1].rstrip())
    T2.insert(END,"INFO: New strains list in "+direct+"list_strains.txt\n")
    T2.tag_add('infolisc', str(WARNING_tot)+'.0', str(WARNING_tot+1)+'.0')
    T2.tag_config('infolisc', foreground='black')
    T2.see(END)
    WARNING_tot += 1
    T2.insert(END,"INFO: New gfm database in "+direct+"\n")
    T2.tag_add('infodbc', str(WARNING_tot)+'.0', str(WARNING_tot+1)+'.0')
    T2.tag_config('infodbc', foreground='black')
    T2.see(END)
    WARNING_tot += 1
    root.config(cursor="")
    root.update()
    info = tkMessageBox.showinfo("Database successfully built : "+str(ret_ls)+" genomes", "Database successfully built, paths transmitted to GeneSpy.\nDatabase is ready to use!")
    actualize_ng()

def ChangeSpec(lb1,path,ss,EdLiWindow):
    global position_list_spec
    try:
        new = ss.get().replace(" [GFM NOT FOUND]","")
    except:
        EdLiWindow.lift()
        return ""
    if str(new).rstrip() != "":
        if len(new.split("\t")) != 3:
            info = tkMessageBox.showinfo("error", "Wrong format. lines have to contain <Assembly>\\t<Name>\\t<Other name>")
            EdLiWindow.lift()
            return ""
        Confirmation = tkMessageBox.askokcancel("Edition of a strain informations","Are you sure to change this strain?")
        # print type(Confirmation)
        if Confirmation is True:
            # print "liaou"
            old = lb1.get(position_list_spec).replace(" [GFM NOT FOUND]","")

            if new.count("\t")==2:
                cont_list = []
                try:
                    cont_list = readfile(path[0])
                except:
                    listbox1.insert(END,"No strains list yet. Format: <Assembly>\\t<Displayed name>\\t<Other name (iTOL)>")
                    EdLiWindow.lift()
                    return ""
                new_cont = []
                for i in cont_list:
                    if i.find(old)!=-1:
                        i = i.replace(old,new.rstrip())
                    new_cont.append(i)
                liste_write = open(path[0],"w")
                [liste_write.write(i) for i in new_cont]
                lb1.delete(0,END)
                for i in new_cont:
                    lf = i.rstrip()
                    if os.path.isfile(path[1]+i.split("\t")[0]+".gfm") is False:
                        lf+= " [GFM NOT FOUND]"
                    lb1.insert(END,lf)
                liste_write.close()
    EdLiWindow.lift()
    actualize_ng()
def EraseSpec(lb1,selection_spec_x,path,EdLiWindow):
    global position_list_spec
    # try:
    strss = selection_spec_x.get()
    # except:
    #     return ""
    if str(strss).rstrip() != "":
        Confirmation = tkMessageBox.askokcancel("Suppression of a strain","Are you sure to erase this strain?")
        if Confirmation is True:
            old = strss.replace(" [GFM NOT FOUND]","")
            # new = ss.get("1.0",END).replace(" [GFM NOT FOUND]","")
            # if new.count("\t")==2:
            cont_list = []
            try:
                cont_list = readfile(path[0])
            except:
                listbox1.insert(END,"No strains list yet. Format: <Assembly>\\t<Displayed name>\\t<Other name (iTOL)>")
                EdLiWindow.lift()
                return ""
            new_cont = []
            for i in cont_list:
                if i.find(old)==-1:
                    new_cont.append(i)
            liste_write = open(path[0],"w")
            [liste_write.write(i) for i in new_cont]
            lb1.delete(0,END)
            for i in new_cont:
                lf = i.rstrip()
                if os.path.isfile(path[1]+i.split("\t")[0]+".gfm") is False:
                    lf+= " [GFM NOT FOUND]"
                lb1.insert(END,lf)
            liste_write.close()
    EdLiWindow.lift()
    actualize_ng()

def AddSelectSpecies(ss,lb):
    try:
        lb.insert(END,ss.get())
    except:
        return ""
def EraseSelectSpec(event, lb,selection_spec_x,path):
    global position_list_spec
    # try:
    strss = selection_spec_x.get()
    # except:
    #     return ""
    if str(strss).rstrip() != "":
            old = strss.replace(" [GFM NOT FOUND]","")
            cont_list = []
            new_cont = []
            cont_list = list(lb.get(0,END))
            for i in cont_list:
                if i.find(old)==-1:
                    new_cont.append(i)
            lb.delete(0,END)
            for i in new_cont:
                lf = i.rstrip()
                if os.path.isfile(path[1]+i.split("\t")[0]+".gfm") is False:
                    lf+= " [GFM NOT FOUND]"
                lb.insert(END,lf)


def get_spec_in_lists(event,lb1,ss):
    global position_list_spec
    try:
        index = lb1.curselection()[0]
        position_list_spec = index
        seltext = lb1.get(index)
        ss.delete(0, END)
        ss.insert(0, seltext)
    except:
        return ""
def AutoSampling(lb1,lb2):
    original = list(lb1.get(0,END))
    sampled = {}
    for i in original:
        try:
            sampled[i.split("\t")[1].split(" ")[0]+i.split("\t")[1].split(" ")[1]] = i
        except:
            sampled[i] = i
    lb2.delete(0,END)
    for k in sorted(sampled.keys()):
        lb2.insert(END,sampled[k])
def SaveSelectionSpec(lb,window):
    global path_infile_g
    global T2
    global WARNING_tot
    try:
        elements  = path_infile_g.split("\\")
        filex = elements.pop()
        folder = "\\".join(elements)
    except:
        folder = ""
    filename_s = asksaveasfilename(initialdir=folder,filetypes = [("text file","*.txt")],title="Save strains list")
    try:
        name_output_file = filename_s.encode("cp1252")
    except:
        return ""
        window.lift()
    if name_output_file != "None":
        if name_output_file != "" and name_output_file != "()":
            name_output_file= name_output_file.replace(".txt","")
            name_output_file += ".txt"
            tab = list(lb.get(0,END))
            out = open(name_output_file,"w")
            for i in tab:
                out.write(i.replace(" [GFM NOT FOUND]","")+"\n")
            out.close()
            T2.insert(END,"INFO: A new strains list has been created in "+name_output_file+"\n")
            T2.tag_add('infolisc', str(WARNING_tot)+'.0', str(WARNING_tot+1)+'.0')
            T2.tag_config('infolisc', foreground='black')
            T2.see(END)
            WARNING_tot += 1
    window.lift()


def EditList(path_init):
    global position_list_spec
    global police
    EdLiWindow= Toplevel()
    EdLiWindow.wm_title("Edit strains list - "+path_init[0])
    EdLiWindow.configure(background="#454545")
    bande1 = Label(EdLiWindow,text="Current list of strains",bg="#454545", height=1, font=police, bd=5, fg="white").grid(row=0,column=1,columnspan=3)
    bande3 = Label(EdLiWindow,bg="#454545", width=1, height=40, bd=5).grid(row=0,column=0,rowspan=7)
    # bande4 = Label(EdLiWindow,bg="#454545", width=100, height=1, bd=5).grid(row=3,column=0,columnspan=5)
    # bande5 = Label(EdLiWindow,bg="#454545", width=100, height=1, bd=5).grid(row=5,column=0,columnspan=5)
    # bande6 = Label(EdLiWindow,bg="#454545", width=1, height=1, bd=5).grid(row=4,column=2)
    # bande3 = Label(EdLiWindow,bg="#454545", width=1, height=1, bd=5).grid(row=4,column=2)
    lab0 = Label(EdLiWindow,text="Assembly   Displayed name   Other name (iTOL)",justify=LEFT,anchor=W, bg="#454545", height=1, bd=5, fg="white").grid(row=1,column=1,columnspan=3)
    listbox1 = Listbox(EdLiWindow, width=50, height=40)
    listbox1.grid(row=2,column=1,columnspan=3,sticky=N+E+W+S)
    scrollbar = Scrollbar(EdLiWindow, orient=VERTICAL ,bg="#454545")
    scrollbar.config(command=listbox1.yview)
    scrollbar.grid(row=2,column=4, sticky=N+S)
    scrollbar2 = Scrollbar(EdLiWindow, orient=HORIZONTAL ,bg="#454545")
    scrollbar2.config(command=listbox1.xview)
    scrollbar2.grid(row=3,column=1,columnspan=3, sticky=E+W)
    listbox1.config(yscrollcommand=scrollbar.set,xscrollcommand=scrollbar2.set)
    bande1 = Label(EdLiWindow,text="Sub-selection of strains",bg="#454545",height=1, font=police, bd=5, fg="white").grid(row=0,column=6,columnspan=3)
    bande3 = Label(EdLiWindow,bg="#454545", width=1, height=40, bd=5).grid(row=0,column=5,rowspan=7)
    lab0 = Label(EdLiWindow,text="Assembly   Displayed name   Other name (iTOL)",justify=LEFT,anchor=W, bg="#454545",height=1, bd=5, fg="white").grid(row=1,column=6,columnspan=3)
    listbox2 = Listbox(EdLiWindow, width=50, height=40)
    listbox2.grid(row=2,column=6,sticky=N+E+W+S,columnspan=3)
    scrollbar3 = Scrollbar(EdLiWindow, orient=VERTICAL ,bg="#454545")
    scrollbar3.config(command=listbox2.yview)
    scrollbar3.grid(row=2,column=9, sticky=N+S)
    scrollbar4 = Scrollbar(EdLiWindow, orient=HORIZONTAL ,bg="#454545")
    scrollbar4.config(command=listbox2.xview)
    scrollbar4.grid(row=3,column=6, sticky=E+W,columnspan=3)
    listbox2.config(yscrollcommand=scrollbar3.set,xscrollcommand=scrollbar4.set)
    bande3 = Label(EdLiWindow,bg="#454545", width=1, height=1, bd=5).grid(row=2,column=10)
    try:
        cont_list = readfile(path_init[0])
        # position = 0
        for i in cont_list:
            lf = i.rstrip()
            if os.path.isfile(path_init[1]+i.split("\t")[0]+".gfm") is False:
                lf+= " [GFM NOT FOUND]"
            listbox1.insert(END,lf)
    except:
        listbox1.insert(END,"No strains list yet. Format: <Assembly>\\t<Displayed name>\\t<Other name (iTOL)>")
    data={"one": 1, "two": 2, "three": 3}
    selection_spec = Entry(EdLiWindow, width=40,  bg="#b2b2b2",bd=3)
    selection_spec.grid(row=4,column=1,columnspan=3,sticky=E+W)
    bande3 = Label(EdLiWindow,bg="#454545", width=1, height=1, bd=5).grid(row=5,column=1)
    listbox1.bind('<ButtonRelease-1>',  lambda event, arg=data: get_spec_in_lists(event, listbox1,selection_spec))
    listbox1.bind('<Double-Button-1>',  lambda event, arg=data: AddSelectSpecies(selection_spec,listbox2))
    change_button = Button (EdLiWindow, text = "Edit strain", command = lambda : ChangeSpec(listbox1,path_init,selection_spec,EdLiWindow), font=police, width=15, height=1)
    erase_button = Button (EdLiWindow, text =  "Delete strain", command = lambda : EraseSpec(listbox1,selection_spec,path_init,EdLiWindow), font=police, width=15, height=1)
    add_button = Button (EdLiWindow, text =  "Add to selection", command = lambda : AddSelectSpecies(selection_spec,listbox2), font=police, width=15, height=1)
    change_button.grid(row=6,column=1,sticky=E+W)
    erase_button.grid(row=6,column=2,sticky=E+W)
    add_button.grid(row=6,column=3,sticky=E+W)
    bande3 = Label(EdLiWindow,bg="#454545", width=1, height=1, bd=5).grid(row=7,column=2)


    selection_spec2 = Entry(EdLiWindow, width=40,  bg="#b2b2b2",bd=3)
    selection_spec2.grid(row=4,column=6,columnspan=3,sticky=E+W)
    # bande3 = Label(EdLiWindow,bg="#454545", width=1, height=1, bd=5).grid(row=5,column=7)
    listbox2.bind('<ButtonRelease-1>',  lambda event, arg=data: get_spec_in_lists(event,listbox2,selection_spec2))
    listbox2.bind('<Delete>',  lambda event, arg=data: EraseSelectSpec(event,listbox2,selection_spec2,path_init))
    del_button2 = Button (EdLiWindow, text = "Delete", command = lambda : EraseSelectSpec("",listbox2,selection_spec2,path_init), font=police, width=15, height=1)
    AS_button = Button (EdLiWindow, text =  "Auto sampling",command = lambda : AutoSampling(listbox1,listbox2) ,font=police, width=15, height=1)
    save_button = Button (EdLiWindow, text =  "Save", command = lambda : SaveSelectionSpec(listbox2,EdLiWindow), font=police, width=15, height=1)
    del_button2.grid(row=6,column=6,sticky=E+W)
    AS_button.grid(row=6,column=7,sticky=E+W)
    save_button.grid(row=6,column=8,sticky=E+W)

    EdLiWindow.columnconfigure(1, weight=1)
    EdLiWindow.columnconfigure(2, weight=1)
    EdLiWindow.columnconfigure(3, weight=1)
    EdLiWindow.columnconfigure(6, weight=1)
    EdLiWindow.columnconfigure(7, weight=1)
    EdLiWindow.columnconfigure(8, weight=1)
    EdLiWindow.rowconfigure(2, weight=1)


def SaveSession():
    global T2
    global path_infile_g
    global WARNING_tot
    global sort_g
    global fen_g
    global col_g
    global data_set_g
    global WP_appear
    global CONTIG_appear
    global Size_arrow
    global global_coloration
    global PATH
    global NAME_appear
    global expansion_g
    global file_color_g
    global LOCTAG_appear
    if path_infile_g != "":
        elements  = path_infile_g.split("\\")
        filex = elements.pop()
        folder = "\\".join(elements)
        filename_s = asksaveasfilename(initialdir=folder,filetypes = [("session file","*.ses")],title="Save session")
        try:
            name_output_file = filename_s.encode("cp1252")+".ses"
        except:
            return ""
        if name_output_file != "None":
            if name_output_file != "" and name_output_file != "()":
                # name_output_file= name_output_file.replace(".ses","")
                name_output_file_w = open(name_output_file, "w")
                name_output_file_w.write(sort_g+"\n"+str(fen_g)+"\n"+col_g+"\n"+data_set_g+"\n"+str(WP_appear)+"\n"+str(CONTIG_appear)+"\n"+str(Size_arrow)+"\n"+global_coloration+"\n"+str(NAME_appear)+"\n"+file_color_g+"\n"+str(expansion_g)+"\n"+str(LOCTAG_appear)+"\n"+str(path_infile_g))
                name_output_file_w.close()
                T2.insert(END,"INFO: Session saved at : "+name_output_file+".ses"+"\n")
                T2.tag_add('infses',  str(WARNING_tot)+'.0', str(WARNING_tot+1)+'.0')
                T2.tag_config('infses', foreground='black')
                T2.see(END)
                WARNING_tot += 1
def OpenSession():
    global T
    global path_infile_g
    global WARNING_tot
    global sort_g
    global fen_g
    global col_g
    global data_set_g
    global WP_appear
    global CONTIG_appear
    global Size_arrow
    global global_coloration
    global PATH
    global NAME_appear
    global expansion_g
    global file_color_g
    global root
    global LOCTAG_appear
    global dico_name_file
    global dico_color_file
    elements  = path_infile_g.split("\\")
    filex = elements.pop()
    folder = "\\".join(elements)
    try:
        session_file = askopenfilename(filetypes = [("session files","*.ses")], title="Open a session", initialdir=folder).encode("cp1252")
    except:
        return ""
    if session_file != "None":
        if session_file != "" and session_file != "()":
            dico_name_file = {}
            Ses_datar = open(session_file)
            cont_temp = Ses_datar.readlines()
            Ses_datar.close()
            try:
                sort_g = cont_temp[0].rstrip()
                fen_g = int(float(cont_temp[1].rstrip()))
                col_g = cont_temp[2].rstrip()
                data_set_g = cont_temp[3].rstrip()
                if cont_temp[4].rstrip() == "False":
                    WP_appear = False
                else:
                    WP_appear = True
                if cont_temp[5].rstrip() == "False":
                    CONTIG_appear = False
                else:
                    CONTIG_appear = True
                Size_arrow = int(cont_temp[6].rstrip())
                global_coloration = cont_temp[7].rstrip()
                if cont_temp[8].rstrip() == "False":
                    NAME_appear = False
                else:
                    NAME_appear = True
                file_color_g = str(cont_temp[9].rstrip())
                expansion_g = float(cont_temp[10].rstrip())
                if cont_temp[11].rstrip() == "False":
                    LOCTAG_appear = False
                else:
                    LOCTAG_appear = True
                # for n,m in enumerate(cont_temp[-(len(cont_temp)-11):]):
                #     m = m.rstrip()
                #     cont_temp
                path_infile = str("\n".join(cont_temp[-(len(cont_temp)-12):])).rstrip()
            # print path_infile_g
            except:
                T2.insert(END,"ERROR: Session file corrupted : "+session_file+"\n")
                T2.tag_add('errses',  str(WARNING_tot)+'.0', str(WARNING_tot+1)+'.0')
                T2.tag_config('errses', foreground='red')
                T2.see(END)
                WARNING_tot += 1
                return ""
            if global_coloration == "file_annot":
                try:
                    file_color_read = readfile(file_color_g)
                    color = ""
                    name = ""
                    for i in file_color_read:
                        if i.find(">")!=-1:
                            tab = i.rstrip().replace(">","").split("\t")
                            color = tab[0]
                            try:
                                name = tab[1]
                            except:
                                name = "NA"
                        else:
                            dico_color_file[i.rstrip().lower()] = color
                            dico_name_file[i.rstrip().lower()] = name
                except:
                    T2.insert(END,"WARNING: Color file not found : "+file_color_g+"\n")
                    T2.tag_add('warnses',  str(WARNING_tot)+'.0', str(WARNING_tot+1)+'.0')
                    T2.tag_config('warnses', foreground='darkorange2')
                    T2.see(END)
                    global_coloration = "normal"
                    WARNING_tot += 1

            if global_coloration == "file_wp":
                try:
                    file_color_read = readfile(file_color_g)
                    color = ""
                    name = ""
                    for i in file_color_read:
                        if i.find(">")!=-1:
                            tab = i.rstrip().replace(">","").split("\t")
                            color = tab[0]
                            try:
                                name = tab[1]
                            except:
                                name = "NA"
                        else:
                            try:
                                dico_color_file[i.split("\t")[1].rstrip()] = color
                                dico_name_file[i.split("\t")[1].rstrip()] = name
                            except:
                                continue
                except:
                    T2.insert(END,"WARNING: Color file not found : "+file_color_g+"\n")
                    T2.tag_add('warnses',  str(WARNING_tot)+'.0', str(WARNING_tot+1)+'.0')
                    T2.tag_config('warnses', foreground='darkorange2')
                    T2.see(END)
                    global_coloration = "normal"
                    WARNING_tot += 1

            if data_set_g == "sele":
                T.delete("1.0",END)
                for i in cont_temp[-(len(cont_temp)-12):]:
                    if i != "\n" and i != "":
                        T.insert(END,i)
                        T.see(END)
                path_infile_g = path_infile
                Context_Launcher(path_infile_g,root,"","multi")
            if data_set_g == "file":
                if os.path.isfile(path_infile) is True:
                    path_infile_g = path_infile
                    Context_Launcher(path_infile_g,root,"","multi")
                else:
                    Clean_Canvas()
                    T2.insert(END,"ERROR: Infile not found : "+path_infile+"\n")
                    T2.tag_add('errses',  str(WARNING_tot)+'.0', str(WARNING_tot+1)+'.0')
                    T2.tag_config('errses', foreground='red')
                    T2.see(END)
                    WARNING_tot += 1



def actualize_ng():
    global number_strains
    global number_gfm
    global number_available_genomes
    global PATH
    global Var_DBA
    try:
        number_strains = len(readfile(PATH[0]))
    except:
        number_strains = 0
    try:
        number_gfm = len(glob.glob(PATH[1]+"*.gfm"))
    except:
        number_gfm = 0
    try:
        number_available_genomes = 0
        cont = glob.glob(PATH[1]+"*.gfm")
        gfm_collection = []
        for i in cont:
            gfm_collection.append(i.split("\\").pop().replace(".gfm",""))

        for i in readfile(PATH[0]):
            if i.split("\t")[0] in gfm_collection:
                number_available_genomes += 1
    except:
        number_available_genomes = 0
    Var_DBA.set("GFM files : "+str(number_gfm)+"\nStrains in list : "+str(number_strains)+"\nOverlap : "+str(number_available_genomes))

def State_db(none):
    global PATH
    DBWindow= Toplevel()
    DBWindow.wm_title("Links between GFM files and strains list")
    DBWindow.configure(background="#454545")
    T_db = Text(DBWindow, width=30, height=40,bg="#b2b2b2",bd=3)
    T_db.grid(row=0,column=0,sticky=N+E+W+S)
    list_strains_test = []
    list_gfms_test = []
    try:
        cont_strains_list = readfile(PATH[0])
        for i in cont_strains_list:
            list_strains_test.append(i.split("\t")[0])
    except:
        print "",
    try:
        cont_gfm_list = glob.glob(PATH[1]+"*.gfm")
        for i in cont_gfm_list:
            list_gfms_test.append(i.split("\\").pop().replace(".gfm",""))
    except:
        print "",
    # print list_gfms_test
    # print list_strains_test
    list_ok = []
    list_orphan_gfm = []
    list_orphan_strain = []
    for i in list_strains_test:
        if i in list_gfms_test:
            list_ok.append(i)
        else:
            list_orphan_strain.append(i)
    for i in list_gfms_test:
        if i not in list_strains_test:
            list_orphan_gfm.append(i)
    T_db.insert(END,"#Orphan GFM files\n")
    for i in list_orphan_gfm:
        T_db.insert(END,i+"\n")
    T_db.insert(END,"#Orphan Strains\n")
    for i in list_orphan_strain:
        T_db.insert(END,i+"\n")
    T_db.insert(END,"#Overlapping genomes\n")
    for i in list_ok:
        T_db.insert(END,i+"\n")
    DBWindow.columnconfigure(0, weight=1)
    DBWindow.rowconfigure(0, weight=1)


# from tkinter.filedialog import *


ColMan = ColorManager()
root = Tk()
root.wm_title("GeneSpy")
police = tkFont.Font(family='Courrier', size=12, weight=tkFont.BOLD)
police2 = tkFont.Font(family='Courrier', size=8, weight=tkFont.BOLD)
root.configure(background="#454545")
root.winfo_toplevel()

##### entete context
Entete5 = Label(root,text="Context of genes", bg="#454545", width=20, height=2, font=police, bd=5, fg="white").grid(row=0,column=1)
############# déclaration des scrolling bar (stickyN+S = barre et non pas des fleches)
scrollbary = Scrollbar(root, orient=VERTICAL,bg="#454545")
scrollbary.grid(row=1,column=2, sticky=N+S, rowspan=14)
#scrollbary.rowconfigure(0, weight=4)
scrollbarx = Scrollbar(root, orient=HORIZONTAL,bg="#454545")
scrollbarx.grid(row=15,column=1, sticky=E+W)
############ creation d'un canvas qui va accueillir ma frame
fond = Canvas(root,yscrollcommand=scrollbary.set,xscrollcommand=scrollbarx.set, width=800, height=200,bg="white")
fond.grid(row=1, column=1, rowspan=14, sticky=N+S+E+W)
############ Mouswheel
def on_mousewheel(event):
	shift = (event.state & 0x1) != 0
	scroll = -1  if event.delta > 0 else 1
	if shift:
		fond.xview_scroll(scroll, "units")
	else:
		fond.yview_scroll(scroll, "units")
root.bind('<MouseWheel>', on_mousewheel)
############ attacheleent des scrollbar sur le canvas
scrollbary.config(command=fond.yview, width = 16)
scrollbarx.config(command=fond.xview, width = 40)
########### attachement du fond sur un frame
frame = Frame(fond,width=20, height=10)
frame.grid(row=0,column=1,sticky=N+E+W+S)
######### empecher le canvas de se resizer
fond.create_window(0, 0,  window=frame)
frame.update_idletasks()
fond.config(scrollregion=fond.bbox("all"))
liste_wid = frame.winfo_children()
###### label des annotations
ann = StringVar()
ann.set("Detail of annotation of proteins, click on figure!")
Annotation = Label(root,textvariable=ann, bg="#b2b2b2", width=20, height=5, font=police, bd=5 )
Annotation.grid(row=17,column=1,rowspan=2,sticky=N+E+W+S)
Annotation.bind("<Button-1>", callback4)
root.columnconfigure(2, pad=10)
Entete0 = Label(root,text="Gene information", bg="#454545", width=20, height=2, font=police, bd=5, fg="white").grid(row=16,column=1)

def motion(event):
    try:
        cid = event.widget.extra
    except:
        root.config(cursor="")
        root.update()
        return ""

    if cid == 'ANNOT' or cid == "DB":
        root.config(cursor="hand1")
        root.update()
    elif cid == 'enlarge':
        root.config(cursor="sb_h_double_arrow")
        root.update()
    else:
        root.config(cursor="")
        root.update()

root.bind('<Motion>', motion)
Annotation.extra = 'ANNOT'
#root.columnconfigure(2, pad=10)
###### entete des menus
Entete4 = Label(root, bg="#454545", width=20, height=1, font=police, bd=5, fg="white").grid(row=15,column=4,columnspan=2)
##### bande laterales
bande1 = Label(root,bg="#454545", width=1, height=20, bd=5).grid(row=0,column=0,columnspan=1,rowspan=14)

initial_pos = 0
def GetInitialPos(event):
    global initial_pos
    x =  event.x
    initial_pos = x
    root.config(cursor="sb_h_double_arrow")
    root.update()
def ResizeBoxes(event):
    global initial_pos
    global root
    global bande2
    tot = root.winfo_width()
    posini = bande2.winfo_x()
    prop_ini =int((posini/float(tot))*70)
    x =  event.x
    delta = int(x)-int(initial_pos)
    prop_new = int(((posini+delta)/float(tot))*70)
    prop_new_rect = (prop_new-48.142)/float(0.0484)
    if prop_new_rect < 0:
        prop_new_rect = 0
    if prop_new_rect > 70:
        prop_new_rect = 70
    root.columnconfigure(1, weight=int(prop_new_rect))
    root.columnconfigure(4, weight=int((70-prop_new_rect)/2))
    root.columnconfigure(5, weight=int((70-prop_new_rect)/2))
    root.config(cursor="")
    root.update()

bande2 = Label(root,bg="#454545", width=1, height=20, bd=5)
bande2.grid(row=0,column=3,columnspan=1,rowspan=14, sticky=N+S)
bande2.bind('<Button-1>', GetInitialPos)
bande2.bind('<ButtonRelease-1>', ResizeBoxes)
bande2.extra = 'enlarge'


bande3 = Label(root,bg="#454545", width=1, height=20, bd=5).grid(row=0,column=7,columnspan=1,rowspan=14)
##### logo
Entete3 = Label(root,text="Database", bg="#454545", width=20, height=1, font=police, bd=5, fg="white" ).grid(row=16,column=4,columnspan=2)
Var_DBA = StringVar()
DBA = Label(root,textvariable=Var_DBA, bg="#b2b2b2", width=20, height=5, font=police, bd=5 )
DBA.grid(row=17,column=4,rowspan=2,columnspan=2,sticky=N+E+W+S)
actualize_ng()
DBA.extra = "DB"
DBA.bind("<Button-1>",State_db)

########fenetre d'export des infos
Entete1 = Label(root,text="Selected Sequences", bg="#454545", width=20, height=2, font=police, bd=5 , fg="white").grid(row=0,column=4,columnspan=2)
root.rowconfigure(0, weight=0,minsize=10)
T = Text(root, width=20, height=20,bg="#b2b2b2",bd=3)
Scr = Scrollbar(root, orient=VERTICAL,bg="#454545")
Scr.grid(row=1,column=6,sticky=N+S,rowspan=5)
Scr.config(command=T.yview)
T.config(yscrollcommand=Scr.set)
T.grid(row=1,column=4, columnspan=2,rowspan=5,sticky=N+E+W+S)
################ fenetre de la boite de dialogue
Entete2 = Label(root,text="Dialog box", bg="#454545", width=20, height=2, font=police, bd=5, fg="white" ).grid(row=7,column=4,columnspan=2)
T2 = Text(root, width=20, height=20, bg="#b2b2b2",bd=3)
Scr2 = Scrollbar(root, orient=VERTICAL,bg="#454545")
Scr2.grid(row=8,column=6,sticky=N+S,rowspan=5)
Scr2.config(command=T2.yview)
T2.config(yscrollcommand=Scr2.set,font=('courier',10, 'bold'))
T2.grid(row=8,column=4, columnspan=2,rowspan=5,sticky=N+E+W+S)
end1 = Label(root, bg="#454545", width=20, height=1, bd=5).grid(row=19,column=1,columnspan=2)
root.bind("<Button-1>", callback)
root.bind("<Button-3>", callback2)
root.bind("<Button-2>", callback3)
root.bind('<Double-Button-1>', callback3)
######bouton selkection
exit = Button (root, text = "Load selection", command = lambda : SelectionLaunch(path_infile_g,root), font=police2)
exit.grid(row=6,column=4,sticky=N+E+W+S)
exit.config( height = 3, width = 11 )
######bouton selkection
exit = Button (root, text = "Clear selection", command = lambda : SelectionClear(),font=police2)
exit.grid(row=6,column=5,sticky=N+E+W+S)
exit.config( height = 3, width = 11 )
########## search in figure
Entete3 = Label(root,text="Search in figure", bg="#454545", width=20, height=2, font=police, bd=5, fg="white" ).grid(row=13,column=4,columnspan=2)
but_search = Button (root, text = "Go to", command = lambda : GoTo(None),font=police)
but_search.grid(row=14,column=4,sticky=N+E+W+S)
but_search.config( height = 2, width = 11 )
entry_search = Entry(root,bg="#b2b2b2",bd=3)
entry_search.grid(row=14,column=5,sticky=N+E+W+S)
entry_search.bind("<Return>", GoTo)
######## Menu
mainmenu = Menu(master=root, bg ="#b2b2b2" )  ## Barre de menu


menu1 = Menu(mainmenu)
mainmenu.add_cascade(label = "File", menu=menu1)
menu1.add_command(label="Load file...", command = lambda : OpenFileMenu(root))
menu1.add_command(label="Save as...", command = lambda : ExportTxt(path_infile_g,tab_genes_g))
menu1.add_command(label="Open session...", command = lambda : OpenSession())
menu1.add_command(label="Save session...", command = lambda : SaveSession())

menu2 = Menu(menu1)
menu1.add_cascade(label = "Export as ...", menu=menu2)
menu1.add_command(label="Load and export...", command = lambda : OpenFileMenuExport(root))
menu1.add_command(label="Quit", command = lambda : close_window(root))
menu2.add_command(label="png", command = lambda: Context_Launcher(path_infile_g,root,"png","mono"))
menu2.add_command(label="svg", command = lambda: Context_Launcher(path_infile_g,root,"svg","mono"))
menu2.add_command(label="pdf", command = lambda: Context_Launcher(path_infile_g,root,"pdf","mono"))
menu2.add_command(label="multiple pdf", command = lambda: multipage(path_infile_g, liste_fig_g,WARNING_g))
menu2.add_command(label="iTOL(<assembly>)", command = lambda : Context_Launcher(path_infile_g,root,"","ITOL1"))
menu2.add_command(label="iTOL(<formatted name>)", command = lambda : Context_Launcher(path_infile_g,root,"","ITOL2"))

menu5 = Menu(mainmenu)
mainmenu.add_cascade(label = "Edit", menu=menu5)
menu5.add_command(label="Color/Binding...", command = lambda: DataMenu(path_anfile_g))
menu5.add_command(label="Strains list...", command = lambda: EditList(PATH))

menu4 = Menu(mainmenu)
mainmenu.add_cascade(label = "Database", menu=menu4)

menu4.add_command(label="Select strains list...", command = lambda: ListPathChoose())
menu4.add_command(label="Select GFM database...", command = lambda:DBPathChoose())
menu4.add_command(label="Basic database building", command = lambda: MenuBDB())
# menu4.add_command(label="Select GFM database...", command = lambda:DBPathChoose())
menu7 = Menu(menu4)
menu4.add_cascade(label = "Advanced database building...", menu=menu7)
menu7.add_command(label="Download...", command = lambda: MenuDownload())
menu7.add_command(label="Format...", command = lambda: FormatageMenu(root))
menu7.add_command(label="Create list...", command = lambda: ListMenu(root))




mainmenu.add_command(label="Search", command = lambda: SearchMenu())
mainmenu.add_command(label="Options", command = lambda: Options(root,col_g,sort_g,path_infile_g))
mainmenu.add_command(label="Refresh", command = lambda:Context_Launcher(path_infile_g,root,"","multi"))

menu6 = Menu(mainmenu)
mainmenu.add_cascade(label = "Help", menu=menu6)
menu6.add_command(label="Documentation", command = lambda : OpenHelp())
menu6.add_command(label="About ...", command = lambda : OpenAbout())


root.bind("<F5>",lambda event, arg1=path_infile_g,arg2=root,arg3="",arg4="multi": Context_Launcher(path_infile_g,root,"","multi"))
root.bind("<Control-s>",lambda event, arg1=path_infile_g,arg2=tab_genes_g : ExportTxt(path_infile_g,tab_genes_g))
root.bind("<Control-q>",lambda event, arg1=root : close_window(root))
root.bind("<Control-o>",lambda event, arg1=root :OpenFileMenu(root))


root.configure(menu = mainmenu)
for i in range(17):
    root.rowconfigure(i, weight=1)
root.columnconfigure(1, weight=50)
root.columnconfigure(4, weight=10)
root.columnconfigure(5, weight=10)
if os.path.isfile(path_anfile_g+"Temp_data.txt") is True:
    #try:
        Temp_datar = open(path_anfile_g+"Temp_data.txt")
        cont_temp = Temp_datar.readlines()
        sort_g = cont_temp[0].rstrip()
        fen_g = int(float(cont_temp[1].rstrip()))
        col_g = cont_temp[2].rstrip()
        data_set_g = cont_temp[3].rstrip()
        if cont_temp[4].rstrip() == "False":
            WP_appear = False
        else:
            WP_appear = True
        if cont_temp[5].rstrip() == "False":
            CONTIG_appear = False
        else:
            CONTIG_appear = True
        Size_arrow = int(cont_temp[6].rstrip())
        global_coloration = cont_temp[7].rstrip()
        threshold_memory = int(cont_temp[8].rstrip())
        if cont_temp[9].rstrip() == "False":
            NAME_appear = False
        else:
            NAME_appear = True
        file_color_g = str(cont_temp[10].rstrip())
        expansion_g = float(cont_temp[11].rstrip())
        if cont_temp[12].rstrip() == "False":
            LOCTAG_appear = False
        else:
            LOCTAG_appear = True
        # for n,m in enumerate(cont_temp[-(len(cont_temp)-11):]):
        #     m = m.rstrip()
        #     cont_temp
        path_infile_g = str("\n".join(cont_temp[-(len(cont_temp)-13):])).rstrip()
        Temp_datar.close()
        # print path_infile_g
        dico_name_file = {}
        if global_coloration == "file_annot":
            file_color_read = readfile(file_color_g)
            color = ""
            name = ""
            for i in file_color_read:
                if i.find(">")!=-1:
                    tab = i.rstrip().replace(">","").split("\t")
                    color = tab[0]
                    try:
                        name = tab[1]
                    except:
                        name = "NA"
                else:
                    dico_color_file[i.rstrip().lower()] = color
                    dico_name_file[i.rstrip().lower()] = name
        if global_coloration == "file_wp":
            file_color_read = readfile(file_color_g)
            color = ""
            name = ""
            for i in file_color_read:
                if i.find(">")!=-1:
                    tab = i.rstrip().replace(">","").split("\t")
                    color = tab[0]
                    try:
                        name = tab[1]
                    except:
                        name = "NA"
                else:
                    try:
                        dico_color_file[i.split("\t")[1].rstrip()] = color
                        dico_name_file[i.split("\t")[1].rstrip()] = name
                    except:
                        continue

        if data_set_g == "sele":
            for i in cont_temp[-(len(cont_temp)-13):]:
                if i != "\n" and i != "":
                    T.insert(END,i)
        Context_Launcher(path_infile_g,root,"","multi")
        os.system("del "+path_anfile_g+"Temp_data.txt")
    #except:
    #    os.system("del "+path_anfile_g+"Temp_data.txt")
    #    print ""


root.mainloop()
